/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.model.core.IDatabase;
import org.eclipse.vtp.desktop.model.core.IDatabaseSet;
import org.eclipse.vtp.desktop.model.core.IWorkflowResource;
import org.eclipse.vtp.desktop.model.core.internal.Database;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowProject;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowResource;

public class DatabaseSet
extends WorkflowResource
implements IDatabaseSet {
    private WorkflowProject project;
    private IFolder folder;

    public DatabaseSet(WorkflowProject project, IFolder folder) {
        this.project = project;
        this.folder = folder;
        this.activateEvents();
    }

    @Override
    public String getName() {
        return this.folder.getName();
    }

    @Override
    protected String getObjectId() {
        return this.folder.getFullPath().toPortableString();
    }

    @Override
    public IWorkflowResource getParent() {
        return this.project;
    }

    @Override
    public List<IDatabase> getDatabases() {
        ArrayList<IDatabase> ret = new ArrayList<IDatabase>();
        try {
            IResource[] res = this.folder.members();
            int i = 0;
            while (i < res.length) {
                if (res[i] instanceof IFolder && !res[i].getName().startsWith(".")) {
                    Database database = new Database(this, (IFolder)res[i]);
                    ret.add(database);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public IDatabase createDatabase(String name) throws CoreException {
        IFolder databaseFolder = this.folder.getFolder(name);
        if (databaseFolder.exists()) {
            throw new IllegalArgumentException("A Database with that name already exists: " + name);
        }
        databaseFolder.create(true, false, null);
        IFile workaround = databaseFolder.getFile(".gitworkaround");
        workaround.create((InputStream)new ByteArrayInputStream("This is a workaround for Git's lack of empty directory support.".getBytes()), true, null);
        Database database = new Database(this, databaseFolder);
        this.refresh();
        return database;
    }

    @Override
    public void deleteDatabase(IDatabase database) {
    }

    public IFolder getUnderlyingFolder() {
        return this.folder;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DatabaseSet) {
            return this.folder.equals((Object)((DatabaseSet)obj).getUnderlyingFolder());
        }
        return false;
    }

    public int hashCode() {
        return this.folder.toString().hashCode();
    }

    @Override
    public List<IWorkflowResource> getChildren() {
        return new ArrayList<IWorkflowResource>(this.getDatabases());
    }

    @Override
    public Object getAdapter(Class adapterClass) {
        if (IResource.class.isAssignableFrom(adapterClass) && adapterClass.isAssignableFrom(this.folder.getClass())) {
            return this.folder;
        }
        if (DatabaseSet.class.isAssignableFrom(adapterClass)) {
            return this;
        }
        return super.getAdapter(adapterClass);
    }
}

