/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.model.core.ColumnType;
import org.eclipse.vtp.desktop.model.core.IDatabaseTable;
import org.eclipse.vtp.desktop.model.core.IDatabaseTableColumn;
import org.eclipse.vtp.desktop.model.core.IWorkflowResource;
import org.eclipse.vtp.desktop.model.core.WorkflowCore;
import org.eclipse.vtp.desktop.model.core.event.ReloadObjectDataEvent;
import org.eclipse.vtp.desktop.model.core.internal.Database;
import org.eclipse.vtp.desktop.model.core.internal.DatabaseTableColumn;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowResource;
import org.eclipse.vtp.desktop.model.core.internal.event.ObjectEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DatabaseTable
extends WorkflowResource
implements IDatabaseTable {
    Database database;
    IFile file;
    String name;
    List<DatabaseTableColumn> columns;

    public DatabaseTable(Database database, IFile file) {
        this.database = database;
        this.file = file;
        this.activateEvents();
        this.loadModel();
    }

    private void loadModel() {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.file.getContents());
            Element rootElement = document.getDocumentElement();
            this.name = rootElement.getAttribute("name");
            this.columns = new ArrayList<DatabaseTableColumn>();
            NodeList nl = rootElement.getElementsByTagName("column");
            int i = 0;
            while (i < nl.getLength()) {
                Element fieldElement = (Element)nl.item(i);
                String fieldName = fieldElement.getAttribute("name");
                NodeList dtnl = fieldElement.getElementsByTagName("column-type");
                if (dtnl.getLength() > 0) {
                    ColumnType fieldDataType = ColumnType.load((Element)dtnl.item(0));
                    DatabaseTableColumn dtc = new DatabaseTableColumn(this, fieldName, fieldDataType);
                    this.columns.add(dtc);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String getObjectId() {
        return this.file.getFullPath().toPortableString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<IDatabaseTableColumn> getColumns() {
        return new ArrayList<IDatabaseTableColumn>(this.columns);
    }

    @Override
    public IWorkflowResource getParent() {
        return this.database;
    }

    @Override
    public void write(InputStream source) throws CoreException {
        this.file.setContents(source, true, true, null);
        WorkflowCore.getDefault().postObjectEvent(new ReloadObjectDataEvent(this.getObjectId()));
    }

    @Override
    public void processObjectEvent(ObjectEvent event) {
        if (event instanceof ReloadObjectDataEvent) {
            this.loadModel();
            this.refresh();
        } else {
            super.processObjectEvent(event);
        }
    }

    @Override
    public void delete() throws CoreException {
        this.file.delete(false, null);
        this.database.refresh();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DatabaseTable) {
            return this.file.equals((Object)((DatabaseTable)obj).getUnderlyingFile());
        }
        return false;
    }

    public int hashCode() {
        return this.file.toString().hashCode();
    }

    @Override
    public Object getAdapter(Class adapterClass) {
        if (IResource.class.isAssignableFrom(adapterClass) && adapterClass.isAssignableFrom(this.file.getClass())) {
            return this.file;
        }
        if (DatabaseTable.class.isAssignableFrom(adapterClass)) {
            return this;
        }
        return super.getAdapter(adapterClass);
    }

    @Override
    public IFile getUnderlyingFile() {
        return this.file;
    }
}

