/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal;

import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.model.core.IDependency;
import org.eclipse.vtp.desktop.model.core.IDependencySet;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.IWorkflowResource;
import org.eclipse.vtp.desktop.model.core.event.ObjectRefreshEvent;
import org.eclipse.vtp.desktop.model.core.internal.Dependency;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowResource;

public class DependencySet
extends WorkflowResource
implements IDependencySet {
    private final IWorkflowProject project;
    private final IFolder folder;

    public DependencySet(IWorkflowProject project, IFolder folder) {
        this.project = project;
        this.folder = folder;
    }

    @Override
    protected String getObjectId() {
        return this.folder.getFullPath().toPortableString();
    }

    @Override
    public String getName() {
        return this.folder.getName();
    }

    @Override
    public IWorkflowResource getParent() {
        return this.project;
    }

    @Override
    public List<IDependency> getDependencies() {
        LinkedList<IDependency> results = new LinkedList<IDependency>();
        try {
            IResource[] members = this.folder.members();
            int i = 0;
            while (i < members.length) {
                if (members[i].getType() == 1) {
                    results.add(new Dependency(this, (IFile)members[i]));
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return results;
    }

    @Override
    public IDependency createDependency(String name, InputStream content) {
        IFile file = this.folder.getFile(name);
        try {
            if (!file.exists()) {
                file.create(content, true, null);
            } else {
                file.setContents(content, true, false, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
        this.processObjectEvent(new ObjectRefreshEvent(this.getObjectId()));
        this.refresh();
        return new Dependency(this, file);
    }

    @Override
    public void removeDependency(IDependency dependency) {
        IFile file = this.folder.getFile(dependency.getName());
        try {
            if (file.exists()) {
                file.delete(true, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.processObjectEvent(new ObjectRefreshEvent(this.getObjectId()));
        this.refresh();
    }

    @Override
    public Object getAdapter(Class adapterClass) {
        if (IResource.class.isAssignableFrom(adapterClass) && adapterClass.isAssignableFrom(this.folder.getClass())) {
            return this.folder;
        }
        if (DependencySet.class.isAssignableFrom(adapterClass)) {
            return this;
        }
        return super.getAdapter(adapterClass);
    }

    @Override
    public List<IWorkflowResource> getChildren() {
        return new LinkedList<IWorkflowResource>(this.getDependencies());
    }

    @Override
    public IFolder getUnderlyingFolder() {
        return this.folder;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DependencySet) {
            return this.folder.equals((Object)((DependencySet)obj).getUnderlyingFolder());
        }
        return false;
    }

    public int hashCode() {
        return this.folder.toString().hashCode();
    }
}

