/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.model.core.IDesignDocument;
import org.eclipse.vtp.desktop.model.core.IDesignFolder;
import org.eclipse.vtp.desktop.model.core.IDesignItemContainer;
import org.eclipse.vtp.desktop.model.core.IWorkflowResource;
import org.eclipse.vtp.desktop.model.core.internal.DesignDocument;
import org.eclipse.vtp.desktop.model.core.internal.DesignFolder;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowResource;
import org.eclipse.vtp.framework.util.Guid;

public abstract class DesignItemContainer
extends WorkflowResource
implements IDesignItemContainer {
    private static final String HASHPREFIX = "DesignItemContainer";
    private IFolder folder = null;

    public DesignItemContainer(IFolder folder) {
        this.folder = folder;
    }

    @Override
    protected String getObjectId() {
        return this.folder.getFullPath().toPortableString();
    }

    @Override
    public IDesignDocument createDesignDocument(String name) {
        DesignDocument document = null;
        try {
            String fileName = String.valueOf(name) + ".canvas";
            IFile designDocument = this.folder.getFile(fileName);
            InputStream templateIn = this.getClass().getClassLoader().getResourceAsStream("design_document_template.xml");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[10240];
            int len = templateIn.read(buf);
            while (len != -1) {
                baos.write(buf, 0, len);
                len = templateIn.read(buf);
            }
            templateIn.close();
            String template = baos.toString();
            template = template.replaceAll("\\[\\[flow_id\\]\\]", Guid.createGUID());
            template = template.replaceAll("\\[\\[portal_id\\]\\]", Guid.createGUID());
            template = template.replaceAll("\\[\\[portal_name\\]\\]", name);
            template = template.replaceAll("\\[\\[canvas_name\\]\\]", name);
            document = new DesignDocument(this, designDocument);
            designDocument.create((InputStream)new ByteArrayInputStream(template.getBytes()), true, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    @Override
    public IDesignFolder createDesignFolder(String name) {
        DesignFolder designFolder = null;
        IFolder newFolder = this.folder.getFolder(name);
        if (newFolder.exists()) {
            throw new IllegalArgumentException("Folder with that name already exists");
        }
        try {
            designFolder = new DesignFolder(this, newFolder);
            newFolder.create(true, true, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return designFolder;
    }

    @Override
    public void deleteDesignDocument(IDesignDocument document) {
        try {
            document.getUnderlyingFile().delete(true, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deleteDesignDocument(String name) {
        IDesignDocument document = this.getDesignDocument(name);
        if (document != null) {
            try {
                document.getUnderlyingFile().delete(true, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void deleteDesignFolder(IDesignFolder designFolder) {
        try {
            designFolder.getUnderlyingFolder().delete(true, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deleteDesignFolder(String name) {
        IDesignFolder designFolder = this.getDesignFolder(name);
        if (designFolder != null) {
            try {
                designFolder.getUnderlyingFolder().delete(true, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public IDesignDocument getDesignDocument(String name) {
        try {
            IResource[] iResourceArray = this.folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                if (child.getType() == 1 && child.getName().equals(name)) {
                    DesignDocument designDocument = new DesignDocument(this, (IFile)child);
                    return designDocument;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public List<IDesignDocument> getDesignDocuments() {
        ArrayList<IDesignDocument> documents = new ArrayList<IDesignDocument>();
        try {
            IResource[] iResourceArray = this.folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                if (child.getType() == 1 && child.getFileExtension() != null && child.getFileExtension().equals("canvas")) {
                    DesignDocument dd = new DesignDocument(this, (IFile)child);
                    documents.add(dd);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return documents;
    }

    @Override
    public IDesignFolder getDesignFolder(String name) {
        try {
            IResource[] iResourceArray = this.folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                if (child.getType() == 2 && child.getName().equals(name)) {
                    DesignFolder designFolder = new DesignFolder(this, (IFolder)child);
                    return designFolder;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public List<IDesignFolder> getDesignFolders() {
        ArrayList<IDesignFolder> folders = new ArrayList<IDesignFolder>();
        try {
            IResource[] iResourceArray = this.folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                if (child.getType() == 2) {
                    DesignFolder designFolder = new DesignFolder(this, (IFolder)child);
                    folders.add(designFolder);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return folders;
    }

    @Override
    public List<IWorkflowResource> getChildren() {
        ArrayList<IWorkflowResource> children = new ArrayList<IWorkflowResource>();
        children.addAll(this.getDesignDocuments());
        children.addAll(this.getDesignFolders());
        return children;
    }

    @Override
    public String getName() {
        return this.folder.getName();
    }

    @Override
    public IFolder getUnderlyingFolder() {
        return this.folder;
    }

    @Override
    public Object getAdapter(Class adapterClass) {
        if (IResource.class.isAssignableFrom(adapterClass) && adapterClass.isAssignableFrom(this.folder.getClass())) {
            return this.folder;
        }
        return super.getAdapter(adapterClass);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DesignItemContainer) {
            return this.folder.equals((Object)((DesignItemContainer)obj).getUnderlyingFolder());
        }
        return false;
    }

    public int hashCode() {
        return (HASHPREFIX + this.folder.toString()).hashCode();
    }
}

