/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Properties;
import org.eclipse.swt.graphics.Point;
import org.eclipse.vtp.desktop.model.core.IDesignDocument;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationException;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationManagerRegistry;
import org.eclipse.vtp.desktop.model.core.design.PaperSize;
import org.eclipse.vtp.desktop.model.core.design.PaperSizeManager;
import org.eclipse.vtp.desktop.model.core.internal.design.Design;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignConnector;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignElement;
import org.eclipse.vtp.desktop.model.core.internal.design.ElementManager;
import org.eclipse.vtp.desktop.model.core.internal.design.ElementResolutionVisitor;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DesignParser {
    public Design parseDesign(IDesignDocument designDocument, Element designElement, ElementResolutionVisitor resolutionVisitor, boolean followExternalReferences) {
        return this.parseDesign(designDocument, null, designElement, resolutionVisitor, followExternalReferences);
    }

    public synchronized Design parseDesign(IDesignDocument designDocument, Design baseDesign, Element designElement, ElementResolutionVisitor resolutionVisitor, boolean followExternalReferences) {
        LinkedList<DesignElement> elements = new LinkedList<DesignElement>();
        HashMap<String, DesignElement> elementsById = new HashMap<String, DesignElement>();
        LinkedList<DesignConnector> connectors = new LinkedList<DesignConnector>();
        HashMap<String, DesignConnector> connectorsById = new HashMap<String, DesignConnector>();
        try {
            int i;
            String flowId = designElement.getAttribute("id");
            String flowName = designElement.getAttribute("name");
            NodeList modelList = designElement.getElementsByTagName("model");
            Element modelElement = (Element)modelList.item(0);
            Design design = new Design(flowId, flowName);
            design.setDocument(designDocument);
            NodeList elementsElementList = modelElement.getElementsByTagName("elements");
            if (elementsElementList.getLength() > 0) {
                Element elementsElement = (Element)elementsElementList.item(0);
                NodeList elementList = elementsElement.getElementsByTagName("element");
                i = 0;
                while (i < elementList.getLength()) {
                    Element elementElement = (Element)elementList.item(i);
                    String elementId = elementElement.getAttribute("id");
                    String elementName = elementElement.getAttribute("name");
                    String elementType = elementElement.getAttribute("type");
                    Properties properties = new Properties();
                    properties.setProperty("followExternalReferences", Boolean.toString(followExternalReferences));
                    NodeList propertiesList = elementElement.getElementsByTagName("properties");
                    if (propertiesList.getLength() > 0) {
                        Element propertiesElement = (Element)propertiesList.item(0);
                        NodeList propertyList = propertiesElement.getElementsByTagName("property");
                        int p = 0;
                        while (p < propertyList.getLength()) {
                            Element propertyElement = (Element)propertyList.item(p);
                            properties.setProperty(propertyElement.getAttribute("name"), propertyElement.getAttribute("value"));
                            ++p;
                        }
                    }
                    DesignElement element = null;
                    element = ElementManager.getInstance().loadElement(elementType, elementId, elementName, properties);
                    if (element != null) {
                        design.addDesignElement(element, false);
                        elements.add(element);
                        elementsById.put(elementId, element);
                        NodeList configurationList = elementElement.getElementsByTagName("configuration");
                        if (configurationList.getLength() > 0) {
                            Element configurationElement = (Element)configurationList.item(0);
                            NodeList managedConfigSectionList = configurationElement.getElementsByTagName("managed-config");
                            int c = 0;
                            while (c < managedConfigSectionList.getLength()) {
                                Element configSectionElement = (Element)managedConfigSectionList.item(c);
                                ConfigurationManager manager = ConfigurationManagerRegistry.getInstance().getConfigurationManager(design, configSectionElement.getAttribute("type"));
                                if (manager != null) {
                                    try {
                                        manager.readConfiguration(configSectionElement);
                                    }
                                    catch (ConfigurationException e) {
                                        e.printStackTrace();
                                    }
                                    element.addConfigurationManager(manager);
                                }
                                ++c;
                            }
                            NodeList customElementList = configurationElement.getElementsByTagNameNS("http://www.eclipse.org/vtp/namespaces/config", "custom-config");
                            if (customElementList.getLength() > 0) {
                                element.readCustomConfiguration((Element)customElementList.item(0));
                            }
                        }
                    }
                    ++i;
                }
            }
            for (DesignElement element : elements) {
                element.resolve();
                if (resolutionVisitor == null) continue;
                resolutionVisitor.resolveElement(element);
            }
            NodeList connectorElementList = modelElement.getElementsByTagName("connectors");
            if (connectorElementList.getLength() > 0) {
                NodeList connectorList = ((Element)connectorElementList.item(0)).getElementsByTagName("connector");
                i = 0;
                while (i < connectorList.getLength()) {
                    DesignElement destination;
                    Element connectorElement = (Element)connectorList.item(i);
                    String id = connectorElement.getAttribute("id");
                    String originId = connectorElement.getAttribute("origin");
                    String destinationId = connectorElement.getAttribute("destination");
                    DesignElement origin = (DesignElement)elementsById.get(originId);
                    if (origin == null && baseDesign != null) {
                        origin = (DesignElement)baseDesign.getDesignElement(originId);
                    }
                    if ((destination = (DesignElement)elementsById.get(destinationId)) == null && baseDesign != null) {
                        destination = (DesignElement)baseDesign.getDesignElement(destinationId);
                    }
                    if (origin == null || destination == null) {
                        throw new RuntimeException("orphaned connector: id=" + id + " origin=" + originId + " destination=" + destinationId);
                    }
                    DesignConnector connector = new DesignConnector(id, origin, destination);
                    NodeList recordList = connectorElement.getElementsByTagName("record");
                    int r = 0;
                    while (r < recordList.getLength()) {
                        Element recordElement = (Element)recordList.item(r);
                        String sourceName = recordElement.getAttribute("sourcename");
                        connector.addConnectionPoint(origin.getConnectorRecord(sourceName));
                        ++r;
                    }
                    design.addDesignConnector(connector);
                    connectors.add(connector);
                    connectorsById.put(id, connector);
                    ++i;
                }
            }
            NodeList canvasList = designElement.getElementsByTagName("design");
            Element canvasElement = (Element)canvasList.item(0);
            int orientation = 2;
            if (!canvasElement.getAttribute("orientation").equals("")) {
                orientation = Integer.parseInt(canvasElement.getAttribute("orientation"));
            }
            String paperSizeId = canvasElement.getAttribute("paper-size");
            PaperSize paperSize = null;
            if (paperSizeId != null && !paperSizeId.equals("")) {
                paperSize = PaperSizeManager.getDefault().getPaperSize(paperSizeId);
            }
            if (paperSize == null) {
                paperSize = PaperSizeManager.getDefault().getPaperSize("org.eclipse.vtp.desktop.model.core.Letter");
            }
            design.setPaperSize(paperSize);
            design.setOrientation(orientation);
            NodeList uiElementList = canvasElement.getElementsByTagName("ui-element");
            int ue = 0;
            while (ue < uiElementList.getLength()) {
                Element uiElementElement = (Element)uiElementList.item(ue);
                String elementId = uiElementElement.getAttribute("id");
                String xs = uiElementElement.getAttribute("x");
                String ys = uiElementElement.getAttribute("y");
                Point centerPoint = new Point(Integer.parseInt(xs), Integer.parseInt(ys));
                DesignElement element = (DesignElement)elementsById.get(elementId);
                if (element != null) {
                    element.setCenterPoint(centerPoint);
                }
                ++ue;
            }
            NodeList uiConnectorList = canvasElement.getElementsByTagName("ui-connector");
            int ue2 = 0;
            while (ue2 < uiConnectorList.getLength()) {
                Element uiConnectorElement = (Element)uiConnectorList.item(ue2);
                String connectorId = uiConnectorElement.getAttribute("id");
                int segment = 0;
                int lx = 0;
                int ly = 0;
                try {
                    segment = Integer.parseInt(uiConnectorElement.getAttribute("label-segment"));
                    lx = Integer.parseInt(uiConnectorElement.getAttribute("label-x"));
                    ly = Integer.parseInt(uiConnectorElement.getAttribute("label-y"));
                }
                catch (Exception configSectionElement) {
                    // empty catch block
                }
                DesignConnector connector = (DesignConnector)connectorsById.get(connectorId);
                if (connector != null) {
                    connector.getConnectorLabel().setPosition(segment, lx, ly);
                    NodeList midPointList = uiConnectorElement.getElementsByTagName("mid-point");
                    int i2 = 0;
                    while (i2 < midPointList.getLength()) {
                        Element midPointElement = (Element)midPointList.item(i2);
                        int x = Integer.parseInt(midPointElement.getAttribute("x"));
                        int y = Integer.parseInt(midPointElement.getAttribute("y"));
                        connector.addMidpoint(x, y);
                        ++i2;
                    }
                }
                ++ue2;
            }
            return design;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

