/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal;

import java.util.List;
import org.eclipse.vtp.desktop.model.core.FieldType;
import org.eclipse.vtp.desktop.model.core.IBusinessObject;
import org.eclipse.vtp.desktop.model.core.IBusinessObjectField;
import org.eclipse.vtp.desktop.model.core.IBusinessObjectSet;
import org.eclipse.vtp.desktop.model.core.design.ObjectDefinition;
import org.eclipse.vtp.desktop.model.core.design.ObjectField;
import org.eclipse.vtp.desktop.model.core.design.Variable;

public class VariableHelper {
    public static Variable constructVariable(String name, IBusinessObjectSet objectSet, FieldType type) {
        Variable v = new Variable(name, type);
        VariableHelper.buildObjectFields(v, objectSet);
        return v;
    }

    public static void buildObjectFields(ObjectDefinition def, IBusinessObjectSet businessObjectSet) {
        if (def.getType().isObject()) {
            List<IBusinessObject> bos = businessObjectSet.getBusinessObjects();
            for (IBusinessObject ibo : bos) {
                if (!ibo.getName().equals(def.getType().getName())) continue;
                List<IBusinessObjectField> fields = ibo.getFields();
                for (IBusinessObjectField ibof : fields) {
                    VariableHelper.buildObjectFields(def.addField(new ObjectField(ibof.getName(), ibof.getDataType(), false)), businessObjectSet);
                }
            }
        } else if (def.getType().getPrimitiveType() == FieldType.Primitive.ARRAY) {
            def.addField(new ObjectField("numberOfItems", FieldType.NUMBER, true));
        } else if (def.getType().getPrimitiveType() == FieldType.Primitive.STRING) {
            def.addField(new ObjectField("length", FieldType.NUMBER, true));
        }
    }
}

