/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal;

import java.io.InputStream;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.model.core.IWebserviceDescriptor;
import org.eclipse.vtp.desktop.model.core.internal.WebserviceSet;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowResource;
import org.eclipse.vtp.desktop.model.core.wsdl.WSDL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class WebserviceDescriptor
extends WorkflowResource
implements IWebserviceDescriptor {
    private static final String HASHPREFIX = "Webservice";
    private final WebserviceSet parent;
    private final IFile file;
    private WSDL wsdl = null;

    public WebserviceDescriptor(WebserviceSet parent, IFile file) {
        this.parent = parent;
        this.file = file;
    }

    @Override
    protected String getObjectId() {
        return this.file.getFullPath().toPortableString();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public WSDL getWSDL() throws Exception {
        if (!this.file.exists()) {
            return null;
        }
        if (this.wsdl == null) {
            try {
                WebserviceDescriptorXMLParser parser = new WebserviceDescriptorXMLParser(this.file.getContents());
                Document document = parser.getDocument();
                Element rootElement = document.getDocumentElement();
                this.wsdl = new WSDL(rootElement);
            }
            catch (Exception ex) {
                throw new Exception("Invalid WSDL", ex);
            }
        }
        return this.wsdl;
    }

    @Override
    public WebserviceSet getParent() {
        return this.parent;
    }

    @Override
    public void delete() throws CoreException {
        this.parent.deleteWebserviceDescriptor(this);
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public Object getAdapter(Class adapterClass) {
        if (IResource.class.isAssignableFrom(adapterClass) && adapterClass.isAssignableFrom(this.file.getClass())) {
            return this.file;
        }
        if (WebserviceDescriptor.class.isAssignableFrom(adapterClass)) {
            return this;
        }
        return super.getAdapter(adapterClass);
    }

    public boolean equals(Object obj) {
        if (obj instanceof WebserviceDescriptor) {
            return this.file.equals((Object)((WebserviceDescriptor)obj).file);
        }
        return false;
    }

    public int hashCode() {
        return (HASHPREFIX + this.file.toString()).hashCode();
    }

    public class WebserviceDescriptorXMLParser
    extends DOMParser {
        private XMLLocator locator;

        public WebserviceDescriptorXMLParser(InputStream input) {
            try {
                this.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
                this.parse(new InputSource(input));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void startElement(QName elementQName, XMLAttributes attrList, Augmentations augs) throws XNIException {
            super.startElement(elementQName, attrList, augs);
            Node node = null;
            try {
                node = (Node)this.getProperty("http://apache.org/xml/properties/dom/current-element-node");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (node != null) {
                node.setUserData("line_Number", String.valueOf(this.locator.getLineNumber()), null);
            }
        }

        public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
            super.startDocument(locator, encoding, namespaceContext, augs);
            this.locator = locator;
            Node node = null;
            try {
                node = (Node)this.getProperty("http://apache.org/xml/properties/dom/current-element-node");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (node != null) {
                node.setUserData("line_Number", String.valueOf(locator.getLineNumber()), null);
            }
        }

        public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
            super.ignorableWhitespace(text, augs);
        }
    }
}

