/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.model.core.IWorkflowModel;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.IWorkflowProjectFactory;
import org.eclipse.vtp.desktop.model.core.IWorkflowResource;
import org.eclipse.vtp.desktop.model.core.IWorkflowResourceContainer;
import org.osgi.framework.Bundle;

public class WorkflowModel
implements IWorkflowModel {
    public static final String workflowProjectFactoryExtensionId = "org.eclipse.vtp.desktop.model.core.workflowProjectFactories";
    private Map<String, IWorkflowProjectFactory> projectFactories = new HashMap<String, IWorkflowProjectFactory>();

    public WorkflowModel() {
        IConfigurationElement[] projectFactoryExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(workflowProjectFactoryExtensionId);
        int i = 0;
        while (i < projectFactoryExtensions.length) {
            String natureId = projectFactoryExtensions[i].getAttribute("nature-id");
            String className = projectFactoryExtensions[i].getAttribute("class");
            Bundle contributor = Platform.getBundle((String)projectFactoryExtensions[i].getContributor().getName());
            try {
                Class factoryClass = contributor.loadClass(className);
                IWorkflowProjectFactory factory = (IWorkflowProjectFactory)factoryClass.newInstance();
                this.projectFactories.put(natureId, factory);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    @Override
    public IWorkflowProject convertToWorkflowProject(IProject project) {
        try {
            String[] natureIds;
            String[] stringArray = natureIds = project.getDescription().getNatureIds();
            int n = natureIds.length;
            int n2 = 0;
            while (n2 < n) {
                String natureId = stringArray[n2];
                IWorkflowProjectFactory factory = this.projectFactories.get(natureId);
                if (factory != null) {
                    return factory.convertToWorkflowProject(project);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public IWorkflowProject createWorkflowProject(String natureId, String name) {
        IWorkflowProjectFactory factory = this.projectFactories.get(natureId);
        if (factory != null) {
            return factory.createWorkflowProject(name);
        }
        return null;
    }

    @Override
    public IWorkflowProject getWorkflowProject(String id) {
        List<IWorkflowProject> projects = this.listWorkflowProjects();
        for (IWorkflowProject workflowProject : projects) {
            if (!workflowProject.getId().equals(id)) continue;
            return workflowProject;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isWorkflowProject(IProject project) {
        if (!project.isOpen()) {
            return false;
        }
        try {
            String[] natureIds;
            String[] stringArray = natureIds = project.getDescription().getNatureIds();
            int n = natureIds.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String natureId = stringArray[n2];
                IWorkflowProjectFactory factory = this.projectFactories.get(natureId);
                if (factory != null) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public List<IWorkflowProject> listWorkflowProjects() {
        IProject[] rawProjects;
        ArrayList<IWorkflowProject> projects = new ArrayList<IWorkflowProject>();
        IProject[] iProjectArray = rawProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = rawProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                String[] natureIds;
                String[] stringArray = natureIds = project.getDescription().getNatureIds();
                int n3 = natureIds.length;
                int n4 = 0;
                while (n4 < n3) {
                    String natureId = stringArray[n4];
                    IWorkflowProjectFactory factory = this.projectFactories.get(natureId);
                    if (factory != null) {
                        projects.add(factory.convertToWorkflowProject(project));
                        break;
                    }
                    ++n4;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return projects;
    }

    @Override
    public IWorkflowResource convertToWorkflowResource(IResource resource) {
        if (resource instanceof IProject && ((IProject)resource).isOpen() && this.isWorkflowProject((IProject)resource)) {
            return this.convertToWorkflowProject((IProject)resource);
        }
        IProject project = resource.getProject();
        if (project != null && this.isWorkflowProject(project)) {
            IWorkflowProject workflowProject = this.convertToWorkflowProject(project);
            LinkedList<IResource> containers = new LinkedList<IResource>();
            containers.add(resource);
            IContainer container = resource.getParent();
            while (container != null && !container.equals((Object)project)) {
                containers.add(0, (IResource)container);
                container = container.getParent();
            }
            return this.locateWorkflowResource(workflowProject, containers);
        }
        return null;
    }

    private IWorkflowResource locateWorkflowResource(IWorkflowResourceContainer parentResource, List<IResource> path) {
        IResource resource = path.remove(0);
        for (IWorkflowResource child : parentResource.getChildren()) {
            IResource adaptedResource = (IResource)child.getAdapter(IResource.class);
            if (adaptedResource == null || !adaptedResource.equals((Object)resource)) continue;
            if (path.isEmpty()) {
                return child;
            }
            if (child instanceof IWorkflowResourceContainer) {
                return this.locateWorkflowResource((IWorkflowResourceContainer)child, path);
            }
            return null;
        }
        return null;
    }
}

