/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.vtp.desktop.model.core.IBusinessObjectSet;
import org.eclipse.vtp.desktop.model.core.IDatabaseSet;
import org.eclipse.vtp.desktop.model.core.IDependencySet;
import org.eclipse.vtp.desktop.model.core.IDesignDocument;
import org.eclipse.vtp.desktop.model.core.IDesignRootFolder;
import org.eclipse.vtp.desktop.model.core.IWebserviceSet;
import org.eclipse.vtp.desktop.model.core.IWorkflowEntry;
import org.eclipse.vtp.desktop.model.core.IWorkflowExit;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.IWorkflowResource;
import org.eclipse.vtp.desktop.model.core.WorkflowCore;
import org.eclipse.vtp.desktop.model.core.branding.BrandManager;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.design.IDesignViewer;
import org.eclipse.vtp.desktop.model.core.event.ReloadObjectDataEvent;
import org.eclipse.vtp.desktop.model.core.internal.BusinessObjectSet;
import org.eclipse.vtp.desktop.model.core.internal.DatabaseSet;
import org.eclipse.vtp.desktop.model.core.internal.DependencySet;
import org.eclipse.vtp.desktop.model.core.internal.DesignRootFolder;
import org.eclipse.vtp.desktop.model.core.internal.WebserviceSet;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowIndex;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowIndexService;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowResource;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowTraversalHelper;
import org.eclipse.vtp.desktop.model.core.internal.branding.Brand;
import org.eclipse.vtp.desktop.model.core.internal.branding.DefaultBrandManager;
import org.eclipse.vtp.framework.util.Guid;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WorkflowProject
extends WorkflowResource
implements IWorkflowProject,
IResourceChangeListener {
    protected IProject project;
    private DefaultBrandManager brandManager = null;
    private String projectId = null;
    private BusinessObjectSet businessObjectSet = null;
    private DependencySet dependencySet = null;
    private DesignRootFolder designRootFolder = null;
    private DatabaseSet databaseSet = null;
    private WebserviceSet webserviceSet = null;

    public WorkflowProject(IProject project) {
        this(project, true);
    }

    protected WorkflowProject(IProject project, boolean initBuildPath) {
        this.project = project;
        this.activateEvents();
        IFolder f = this.getOrCreateFolder(project, "Dependencies");
        this.dependencySet = new DependencySet(this, f);
        f = this.getOrCreateFolder(project, "Business Objects");
        this.businessObjectSet = new BusinessObjectSet(this, f);
        f = this.getOrCreateFolder(project, "Databases");
        this.databaseSet = new DatabaseSet(this, f);
        f = this.getOrCreateFolder(project, "Webservices");
        this.webserviceSet = new WebserviceSet(this, f);
        f = this.getOrCreateFolder(project, "Workflow Design");
        this.designRootFolder = new DesignRootFolder(this, f);
        if (initBuildPath) {
            this.loadBuildPath();
        }
    }

    @Override
    public String getId() {
        return this.projectId;
    }

    @Override
    public String getName() {
        return this.project.getName();
    }

    @Override
    public IWorkflowResource getParent() {
        return null;
    }

    @Override
    public IWorkflowProject getProject() {
        return this;
    }

    @Override
    public BrandManager getBrandManager() {
        return this.brandManager;
    }

    @Override
    public IBusinessObjectSet getBusinessObjectSet() {
        return this.businessObjectSet;
    }

    @Override
    public IDependencySet getDependencySet() {
        return this.dependencySet;
    }

    @Override
    public IDatabaseSet getDatabaseSet() {
        return this.databaseSet;
    }

    @Override
    public IWebserviceSet getWebserviceSet() {
        return this.webserviceSet;
    }

    @Override
    public IDesignRootFolder getDesignRootFolder() {
        return this.designRootFolder;
    }

    @Override
    public IWorkflowEntry getWorkflowEntry(String id) {
        WorkflowTraversalHelper wth = new WorkflowTraversalHelper(this, new LinkedList<IDesignDocument>());
        return wth.getWorkflowEntry(id);
    }

    @Override
    public IWorkflowEntry getWorkflowEntryByName(String name) {
        WorkflowTraversalHelper wth = new WorkflowTraversalHelper(this, new LinkedList<IDesignDocument>());
        for (IWorkflowEntry entry : wth.getAllWorkflowEntries()) {
            if (!entry.getName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public List<IWorkflowEntry> getWorkflowEntries() {
        WorkflowTraversalHelper wth = new WorkflowTraversalHelper(this, new LinkedList<IDesignDocument>());
        return wth.getAllWorkflowEntries();
    }

    @Override
    public List<IWorkflowExit> getWorkflowExits(IWorkflowEntry entryPoint) {
        return null;
    }

    @Override
    public List<IWorkflowResource> getChildren() {
        LinkedList<IWorkflowResource> children = new LinkedList<IWorkflowResource>();
        children.add(this.designRootFolder);
        children.add(this.businessObjectSet);
        children.add(this.databaseSet);
        children.add(this.webserviceSet);
        children.add(this.dependencySet);
        return children;
    }

    @Override
    public IProject getUnderlyingProject() {
        return this.project;
    }

    @Override
    protected String getObjectId() {
        return this.project.getFullPath().toPortableString();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter.equals(IResource.class) && adapter.isAssignableFrom(this.project.getClass())) {
            return this.project;
        }
        if (adapter.equals(IProject.class)) {
            return this.project;
        }
        return super.getAdapter(adapter);
    }

    protected final synchronized void loadBuildPath() {
        try {
            IFile buildPath = this.project.getFile(".buildPath");
            if (!buildPath.exists()) {
                this.initializeBuildPath();
                this.storeBuildPath();
            }
            DocumentBuilderFactory buildFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = buildFactory.newDocumentBuilder();
            Document doc = builder.parse(buildPath.getContents());
            Element root = doc.getDocumentElement();
            this.projectId = root.getAttribute("id");
            NodeList sectionList = root.getChildNodes();
            int i = 0;
            while (i < sectionList.getLength()) {
                if (sectionList.item(i).getNodeType() == 1) {
                    this.loadBuildPathSection((Element)sectionList.item(i));
                }
                ++i;
            }
            this.project.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void loadBuildPathSection(Element sectionElement) {
        if (sectionElement.getNodeName().equals("brands")) {
            this.brandManager = new DefaultBrandManager();
            NodeList nl = sectionElement.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                if (nl.item(i).getNodeType() == 1) {
                    Element brandElement = (Element)nl.item(i);
                    String brandId = brandElement.getAttribute("id");
                    Brand defaultBrand = new Brand(brandId, brandElement.getAttribute("name"));
                    this.brandManager.setDefaultBrand(defaultBrand);
                    NodeList subBrandList = brandElement.getChildNodes();
                    this.addBrands(defaultBrand, subBrandList);
                }
                ++i;
            }
        }
    }

    private void addBrands(Brand parent, NodeList brandList) {
        int i = 0;
        while (i < brandList.getLength()) {
            if (brandList.item(i).getNodeType() == 1) {
                Element brandElement = (Element)brandList.item(i);
                String brandId = brandElement.getAttribute("id");
                Brand brand = new Brand(brandId, brandElement.getAttribute("name"));
                brand.setParent(parent);
                this.addBrands(brand, brandElement.getChildNodes());
            }
            ++i;
        }
    }

    public final void storeBuildPath() {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element rootElement = document.createElement("workflow-settings");
            document.appendChild(rootElement);
            rootElement.setAttribute("id", this.projectId);
            this.writeBuildPathSections(rootElement);
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(document);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(baos);
            trans.setOutputProperty("encoding", "UTF-8");
            trans.transform(source, result);
            IFile buildPath = this.project.getFile(".buildPath");
            if (!buildPath.exists()) {
                buildPath.create((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, null);
            } else {
                buildPath.setContents((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, false, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        WorkflowCore.getDefault().postObjectEvent(new ReloadObjectDataEvent(this.getObjectId()));
    }

    protected void writeBuildPathSections(Element rootElement) {
        Document document = rootElement.getOwnerDocument();
        Element brandsElement = document.createElement("brands");
        rootElement.appendChild(brandsElement);
        IBrand defaultBrand = this.brandManager.getDefaultBrand();
        this.writeBrand(brandsElement, defaultBrand);
    }

    private void writeBrand(Element parentElement, IBrand brand) {
        Element brandElement = parentElement.getOwnerDocument().createElement("brand");
        parentElement.appendChild(brandElement);
        brandElement.setAttribute("id", brand.getId());
        brandElement.setAttribute("name", brand.getName());
        List<IBrand> children = brand.getChildBrands();
        for (IBrand child : children) {
            this.writeBrand(brandElement, child);
        }
    }

    protected void initializeBuildPath() {
        this.projectId = Guid.createGUID();
        this.brandManager = new DefaultBrandManager();
        Brand defaultBrand = new Brand(Guid.createGUID(), "Default");
        this.brandManager.setDefaultBrand(defaultBrand);
    }

    @Override
    public void finalize() {
        this.project.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta rootDelta = event.getDelta();
        try {
            rootDelta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    if (delta.getResource().equals((Object)WorkflowProject.this.project.getFile(".buildPath")) && delta.getKind() == 4) {
                        WorkflowProject.this.loadBuildPath();
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void navigateToElement(String elementId) {
        IWorkflowResource workflowResource;
        IFile file;
        WorkflowIndex index = WorkflowIndexService.getInstance().getIndex(this.getUnderlyingProject());
        String documentPath = index.locateElement(elementId);
        if (documentPath != null && (file = this.getUnderlyingProject().getFile(documentPath)).exists() && (workflowResource = WorkflowCore.getDefault().getWorkflowModel().convertToWorkflowResource((IResource)file)) instanceof IDesignDocument) {
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (workbenchWindow == null && PlatformUI.getWorkbench().getWorkbenchWindowCount() > 0) {
                workbenchWindow = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
            }
            if (workbenchWindow != null) {
                try {
                    IEditorPart editor = IDE.openEditor((IWorkbenchPage)workbenchWindow.getActivePage(), (IFile)file, (boolean)true);
                    if (editor instanceof IDesignViewer) {
                        ((IDesignViewer)editor).displayElement(elementId);
                        return;
                    }
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        }
        System.err.println("could not locate element: " + elementId);
    }

    private IFolder getOrCreateFolder(IProject parent, String name) {
        IFolder f = parent.getFolder(name);
        if (!f.exists()) {
            try {
                f.create(true, true, null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return f;
    }
}

