/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.IWorkflowResource;
import org.eclipse.vtp.desktop.model.core.WorkflowCore;
import org.eclipse.vtp.desktop.model.core.event.IRefreshListener;
import org.eclipse.vtp.desktop.model.core.event.ObjectRefreshEvent;
import org.eclipse.vtp.desktop.model.core.internal.event.ObjectEvent;
import org.eclipse.vtp.desktop.model.core.internal.event.ObjectListener;

public abstract class WorkflowResource
implements IWorkflowResource,
ObjectListener,
IContributorResourceAdapter {
    List<IRefreshListener> refreshListeners = new ArrayList<IRefreshListener>();

    @Override
    public IWorkflowProject getProject() {
        return this.getParent().getProject();
    }

    protected void activateEvents() {
        WorkflowCore.getDefault().registerObjectListener(this.getObjectId(), this);
    }

    protected void finalize() throws Throwable {
        WorkflowCore.getDefault().unregisterObjectListener(this.getObjectId(), this);
        super.finalize();
    }

    protected abstract String getObjectId();

    @Override
    public void deferEvents() {
        WorkflowCore.getDefault().deferEvents(this.getObjectId());
    }

    @Override
    public void resumeEvents() {
        WorkflowCore.getDefault().resumeEvents(this.getObjectId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRefreshListener(IRefreshListener l) {
        List<IRefreshListener> list = this.refreshListeners;
        synchronized (list) {
            this.refreshListeners.remove(l);
            this.refreshListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRefreshListener(IRefreshListener l) {
        List<IRefreshListener> list = this.refreshListeners;
        synchronized (list) {
            this.refreshListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processObjectEvent(ObjectEvent event) {
        if (event instanceof ObjectRefreshEvent) {
            List<IRefreshListener> list = this.refreshListeners;
            synchronized (list) {
                for (IRefreshListener l : this.refreshListeners) {
                    l.refreshResource(this);
                }
            }
        }
    }

    @Override
    public void refresh() {
        WorkflowCore.getDefault().postObjectEvent(new ObjectRefreshEvent(this.getObjectId()));
    }

    public Object getAdapter(Class adapter) {
        if (IContributorResourceAdapter.class.isAssignableFrom(adapter)) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IResource getAdaptedResource(IAdaptable adaptable) {
        return (IResource)this.getAdapter(IResource.class);
    }
}

