/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal.branding;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationContext;

public class BrandContext
implements ConfigurationContext {
    public static final String CONTEXT_ID = "org.eclipse.vtp.desktop.model.core.brandcontext";
    private static final String CONTEXT_NAME = "Brands";
    private IWorkflowProject project = null;

    @Override
    public String getId() {
        return CONTEXT_ID;
    }

    @Override
    public String getName() {
        return CONTEXT_NAME;
    }

    @Override
    public void setProject(IWorkflowProject project) {
        this.project = project;
    }

    @Override
    public String getLabel(Object obj) {
        if (obj instanceof IBrand) {
            IBrand brand = (IBrand)obj;
            IBrand parent = brand.getParent();
            int indent = 0;
            while (parent != null) {
                ++indent;
                parent = parent.getParent();
            }
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while (i < indent) {
                builder.append("   ");
                ++i;
            }
            builder.append(brand.getName());
            return builder.toString();
        }
        return null;
    }

    @Override
    public List<Object> getValues() {
        ArrayList<Object> ret = new ArrayList<Object>();
        IBrand defaultBrand = this.project.getBrandManager().getDefaultBrand();
        ret.add(defaultBrand);
        this.traverseBrands(defaultBrand, ret);
        return ret;
    }

    private void traverseBrands(IBrand parent, List<Object> brands) {
        for (IBrand child : parent.getChildBrands()) {
            brands.add(child);
            this.traverseBrands(child, brands);
        }
    }

    @Override
    public boolean setConfigurationContext(Map<String, Object> values) {
        return false;
    }
}

