/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal.branding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.desktop.model.core.branding.BrandManager;
import org.eclipse.vtp.desktop.model.core.branding.BrandManagerListener;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.internal.branding.Brand;

public class DefaultBrandManager
implements BrandManager {
    private Brand defaultBrand;
    private List<BrandManagerListener> listeners = new LinkedList<BrandManagerListener>();
    private Map<String, IBrand> brandMap = new HashMap<String, IBrand>();
    private Map<String, List<String>> supportedLanguages = new HashMap<String, List<String>>();
    private List<String> supportedInteractions = new ArrayList<String>();

    @Override
    public void fireBrandAdded(IBrand brand) {
        this.brandMap.put(brand.getName(), brand);
        for (BrandManagerListener listener : this.listeners) {
            try {
                listener.brandAdded(brand);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void fireBrandNameChanged(IBrand brand, String oldName) {
        for (BrandManagerListener listener : this.listeners) {
            try {
                listener.brandNameChanged(brand, oldName);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void fireBrandParentChanged(IBrand brand, IBrand oldParent) {
        for (BrandManagerListener listener : this.listeners) {
            try {
                listener.brandParentChanged(brand, oldParent);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void fireBrandRemoved(IBrand brand) {
        this.brandMap.remove(brand.getName());
        for (BrandManagerListener listener : this.listeners) {
            try {
                listener.brandRemoved(brand);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public IBrand getDefaultBrand() {
        return this.defaultBrand;
    }

    public void setDefaultBrand(IBrand defaultBrand) {
        if (this.defaultBrand != null) {
            this.brandMap.remove(this.defaultBrand.getName());
        }
        this.defaultBrand = (Brand)defaultBrand;
        this.defaultBrand.setManager(this);
        this.brandMap.put(defaultBrand.getName(), defaultBrand);
    }

    @Override
    public void addListener(BrandManagerListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(BrandManagerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean checkBrandName(String name) {
        return this.brandMap.get(name) == null;
    }

    @Override
    public Brand getBrand(String name) {
        return (Brand)this.brandMap.get(name);
    }

    public List<String> getSupportedInteractionTypes() {
        return this.supportedInteractions;
    }

    public void addInteractionSupport(String interactionType) {
        if (!this.supportedInteractions.contains(interactionType)) {
            this.supportedInteractions.add(interactionType);
        }
    }

    public List<String> getSupportedLanguages(String interactionType) {
        List<String> ret = this.supportedLanguages.get(interactionType);
        if (ret == null) {
            ret = new ArrayList<String>();
        }
        return ret;
    }

    public void addSupportedLanguage(String interactionType, String language) {
        List<String> ret = this.supportedLanguages.get(interactionType);
        if (ret == null) {
            ret = new ArrayList<String>();
            this.supportedLanguages.put(interactionType, ret);
        }
        ret.remove(language);
        ret.add(language);
    }
}

