/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal.design;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.vtp.desktop.model.core.design.IDesignComponent;
import org.eclipse.vtp.desktop.model.core.design.IDesignComponentListener;
import org.eclipse.vtp.desktop.model.core.internal.design.Design;
import org.eclipse.vtp.framework.util.Guid;

public abstract class DesignComponent
implements IDesignComponent {
    private String id;
    private Design design;
    List<IDesignComponentListener> listeners = new LinkedList<IDesignComponentListener>();
    List<PropertyChangeListener> propertyListeners = new LinkedList<PropertyChangeListener>();

    public DesignComponent() {
        this.id = Guid.createGUID();
    }

    public DesignComponent(String id) {
        this.id = id;
    }

    @Override
    public Design getDesign() {
        return this.design;
    }

    public void setDesign(Design design) {
        this.design = design;
    }

    @Override
    public String getId() {
        return this.id;
    }

    protected void setId(String id) {
        System.out.println("Changing the id of: " + this + " to " + id);
        String oldId = this.id;
        this.id = id;
        this.firePropertyChange("model.element.id", oldId, id);
    }

    @Override
    public void addListener(IDesignComponentListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IDesignComponentListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void addPropertyListener(PropertyChangeListener listener) {
        this.propertyListeners.remove(listener);
        this.propertyListeners.add(listener);
    }

    @Override
    public void removePropertyListener(PropertyChangeListener listener) {
        this.propertyListeners.remove(listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (PropertyChangeListener listener : this.propertyListeners) {
            listener.propertyChange(event);
        }
    }

    protected void fireChange() {
        for (IDesignComponentListener listener : this.listeners) {
            listener.componentChanged(this);
        }
    }

    protected void fireDelete() {
        for (IDesignComponentListener listener : this.listeners) {
            listener.componentDeleted(this);
        }
    }

    protected void delete() {
        this.fireDelete();
    }
}

