/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal.design;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.swt.graphics.Point;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationManagerRegistry;
import org.eclipse.vtp.desktop.model.core.design.IDesign;
import org.eclipse.vtp.desktop.model.core.design.IDesignConnector;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.design.IExitBroadcastReceiver;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignComponent;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignConnector;
import org.w3c.dom.Element;

public abstract class DesignElement
extends DesignComponent
implements IDesignElement {
    private String name;
    private Properties properties = new Properties();
    private Point centerPoint = null;
    private boolean hasErrors = false;
    private boolean hasWarnings = false;
    private boolean hasTodo = false;
    private Map<String, ConfigurationManager> configurationManagersByType;
    private List<ConfigurationManager> configurationManagers;
    private List<DesignConnector> incomingConnectors = new ArrayList<DesignConnector>();
    private Map<String, ConfigRefCount> configRefs = new HashMap<String, ConfigRefCount>();

    public DesignElement(String name) {
        this.name = name;
        this.configurationManagersByType = new HashMap<String, ConfigurationManager>();
        this.configurationManagers = new ArrayList<ConfigurationManager>();
    }

    public DesignElement(String id, String name, Properties properties) {
        super(id);
        this.name = name;
        this.properties = properties;
        this.configurationManagersByType = new HashMap<String, ConfigurationManager>();
        this.configurationManagers = new ArrayList<ConfigurationManager>();
    }

    @Override
    public List<IExitBroadcastReceiver> getExitBroadcastReceivers() {
        return Collections.emptyList();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.firePropertyChange("model.element.name", oldName, name);
        this.fireChange();
    }

    @Override
    public String getTitle() {
        return String.valueOf(this.getName()) + " Properties";
    }

    @Override
    public boolean canDelete() {
        return true;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public void addConfigurationManager(ConfigurationManager manager) {
        this.configurationManagersByType.put(manager.getType(), manager);
        this.configurationManagers.add(manager);
    }

    @Override
    public ConfigurationManager getConfigurationManager(String type) {
        ConfigRefCount ref;
        System.err.println("getting manager:" + type);
        ConfigurationManager cm = this.configurationManagersByType.get(type);
        if (cm == null) {
            System.err.println("creating new manager instance");
            cm = ConfigurationManagerRegistry.getInstance().getConfigurationManager(this.getDesign(), type);
            if (cm != null) {
                this.configurationManagers.add(cm);
                this.configurationManagersByType.put(type, cm);
            } else {
                return null;
            }
        }
        if ((ref = this.configRefs.get(type)) == null) {
            ref = new ConfigRefCount();
            ref.configType = type;
            ref.copy = (ConfigurationManager)cm.clone();
            this.configRefs.put(type, ref);
        }
        ConfigRefCount configRefCount = ref;
        configRefCount.refs = configRefCount.refs + 1;
        System.err.println("manager " + ref.copy + " ref count: " + ref.refs);
        return ref.copy;
    }

    @Override
    public void commitConfigurationChanges(ConfigurationManager manager) {
        System.out.println("committing manager: " + manager);
        ConfigRefCount ref = this.configRefs.get(manager.getType());
        if (ref == null) {
            System.err.println("Big problems!  no ref counter for " + manager);
            return;
        }
        ConfigRefCount configRefCount = ref;
        configRefCount.refs = configRefCount.refs - 1;
        System.err.println("Reference count: " + ref.refs);
        if (ref.refs == 0) {
            this.configRefs.remove(manager.getType());
            ConfigurationManager cm = this.configurationManagersByType.get(manager.getType());
            this.configurationManagers.remove(cm);
            this.configurationManagers.add(manager);
            this.configurationManagersByType.put(manager.getType(), manager);
        }
        this.fireChange();
    }

    @Override
    public void rollbackConfigurationChanges(ConfigurationManager manager) {
        System.out.println("rolling back manager: " + manager);
        this.configRefs.remove(manager.getType());
    }

    public List<ConfigurationManager> listConfigurationManagers() {
        return Collections.unmodifiableList(this.configurationManagers);
    }

    public void addIncomingConnector(DesignConnector connector) {
        this.incomingConnectors.remove(connector);
        this.incomingConnectors.add(connector);
    }

    public void removeIncomingConnector(DesignConnector connector) {
        this.incomingConnectors.remove(connector);
    }

    @Override
    public List<IDesignConnector> getIncomingConnectors() {
        LinkedList<IDesignConnector> ret = new LinkedList<IDesignConnector>();
        ret.addAll(this.incomingConnectors);
        return ret;
    }

    @Override
    public List<Variable> getOutgoingVariables(String exitPoint) {
        return this.getOutgoingVariables(exitPoint, false);
    }

    @Override
    public List<Variable> getOutgoingVariables(String exitPoint, boolean localOnly) {
        return new LinkedList<Variable>();
    }

    public boolean hasPathToStart(Map<String, IDesignElement> originPath) {
        if (originPath == null) {
            originPath = new HashMap<String, IDesignElement>();
        }
        originPath.put(this.getId(), this);
        boolean ret = false;
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            boolean has;
            DesignConnector connector = this.incomingConnectors.get(i);
            if (originPath.get(connector.getOrigin().getId()) == null && (ret |= (has = connector.getOrigin().hasPathToStart(originPath)))) {
                return ret;
            }
            ++i;
        }
        return ret;
    }

    public void resolve() {
    }

    @Override
    public boolean hasErrors() {
        return this.hasErrors;
    }

    @Override
    public boolean hasWarnings() {
        return this.hasWarnings;
    }

    @Override
    public boolean hasTodo() {
        return this.hasTodo;
    }

    public void validateStatus() {
        this.hasErrors = !this.hasPathToStart(null);
        this.hasWarnings = false;
        this.hasTodo = false;
        for (IDesignElementConnectionPoint cr : this.getConnectorRecords(IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT)) {
            if (cr.getDesignConnector() != null) continue;
            this.hasWarnings = true;
            break;
        }
        for (IDesignElementConnectionPoint cr : this.getConnectorRecords(IDesignElementConnectionPoint.ConnectionPointType.ERROR_POINT)) {
            if (cr.getDesignConnector() != null) continue;
            this.hasTodo = true;
            break;
        }
    }

    public abstract void readCustomConfiguration(Element var1);

    public abstract void writeCustomConfiguration(Element var1);

    public void declareBusinessObjects() {
    }

    @Override
    public Point getCenterPoint() {
        return this.centerPoint;
    }

    @Override
    public void setCenterPoint(int x, int y) {
        this.centerPoint = new Point(x, y);
        this.fireChange();
    }

    @Override
    public void setCenterPoint(Point centerPoint) {
        this.centerPoint = centerPoint;
        this.fireChange();
    }

    @Override
    public boolean canBeContainedBy(IDesign design) {
        return true;
    }

    private class ConfigRefCount {
        private String configType;
        private int refs = 0;
        private ConfigurationManager copy;

        private ConfigRefCount() {
        }
    }
}

