/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal.design;

import java.util.LinkedList;
import java.util.List;

public class ModelValidationResult {
    public static final int FAIL_ON_ERROR = 0;
    public static final int FAIL_ON_WARNING = 1;
    public static final int FAIL_ON_INFO = 2;
    private boolean failOnWarning = false;
    private boolean failOnInfo = false;
    private List<String> validationErrors = new LinkedList<String>();
    private List<String> validationWarnings = new LinkedList<String>();
    private List<String> validationInformation = new LinkedList<String>();

    public ModelValidationResult(int failureFlags) {
        this.failOnWarning = (failureFlags & 1) > 0;
        this.failOnInfo = (failureFlags & 2) > 0;
    }

    public void addError(String error) {
        this.validationErrors.add(error);
    }

    public void addWarning(String warning) {
        this.validationWarnings.add(warning);
    }

    public void addInformation(String information) {
        this.validationInformation.add(information);
    }

    public List<String> getErrors() {
        return this.validationErrors;
    }

    public List<String> getWarnings() {
        return this.validationWarnings;
    }

    public List<String> getInformation() {
        return this.validationInformation;
    }

    public boolean isValid() {
        return !(this.validationErrors.size() != 0 || this.failOnWarning && this.validationWarnings.size() >= 1 || this.failOnInfo && this.validationInformation.size() >= 1);
    }
}

