/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.wsdl;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.vtp.desktop.model.core.schema.ElementItem;
import org.eclipse.vtp.desktop.model.core.schema.Schema;
import org.eclipse.vtp.desktop.model.core.schema.SchemaProblem;
import org.eclipse.vtp.desktop.model.core.schema.Type;
import org.eclipse.vtp.desktop.model.core.wsdl.BidirectionalOperation;
import org.eclipse.vtp.desktop.model.core.wsdl.Binding;
import org.eclipse.vtp.desktop.model.core.wsdl.ElementPart;
import org.eclipse.vtp.desktop.model.core.wsdl.Message;
import org.eclipse.vtp.desktop.model.core.wsdl.Operation;
import org.eclipse.vtp.desktop.model.core.wsdl.OperationElement;
import org.eclipse.vtp.desktop.model.core.wsdl.Part;
import org.eclipse.vtp.desktop.model.core.wsdl.Port;
import org.eclipse.vtp.desktop.model.core.wsdl.PortType;
import org.eclipse.vtp.desktop.model.core.wsdl.Service;
import org.eclipse.vtp.desktop.model.core.wsdl.TypedPart;
import org.eclipse.vtp.desktop.model.core.wsdl.UnidirectionalOperation;
import org.eclipse.vtp.desktop.model.core.wsdl.WSDLProblem;
import org.eclipse.vtp.desktop.model.core.wsdl.soap.SoapBinding;
import org.eclipse.vtp.desktop.model.core.wsdl.soap.SoapBindingOperation;
import org.eclipse.vtp.desktop.model.core.wsdl.soap.SoapBindingOperationElement;
import org.eclipse.vtp.desktop.model.core.wsdl.soap.SoapBody;
import org.eclipse.vtp.desktop.model.core.wsdl.soap.SoapFault;
import org.eclipse.vtp.desktop.model.core.wsdl.soap.SoapHeader;
import org.eclipse.vtp.desktop.model.core.wsdl.soap.SoapHeaderFault;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSDL {
    public static final String WSDL_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";
    private String targetNamespace = null;
    private Map<String, WSDL> wsdlsByNamespace = new HashMap<String, WSDL>();
    private List<Schema> schemas = new LinkedList<Schema>();
    private Map<String, Message> messagesByName = new HashMap<String, Message>();
    private Map<String, PortType> portTypesByName = new HashMap<String, PortType>();
    private Map<String, Binding> bindingsByName = new HashMap<String, Binding>();
    private Map<String, Service> servicesByName = new HashMap<String, Service>();
    private List<WSDLProblem> problems = new LinkedList<WSDLProblem>();

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public WSDL(Element wsdlElement) {
        super();
        this.targetNamespace = wsdlElement.getAttribute("targetNamespace");
        this.schemas.add(Schema.DEFAULT_SCHEMA);
        imports = XMLUtilities.getElementsByTagNameNS((Element)wsdlElement, (String)"http://schemas.xmlsoap.org/wsdl/", (String)"import", (boolean)true);
        i = 0;
        while (i < imports.size()) {
            block47: {
                block48: {
                    namespaceAttr = ((Element)imports.get(i)).getAttributeNode("namespace");
                    if (namespaceAttr != null && this.wsdlsByNamespace.get(namespaceAttr.getValue()) != null) break block47;
                    locationUri = null;
                    locationAttr = ((Element)imports.get(i)).getAttributeNode("location");
                    if (locationAttr == null) break block48;
                    locationUri = locationAttr.getValue();
                    ** GOTO lbl28
                }
                if (namespaceAttr == null) {
                    this.addProblem(this.createProblem("No URI source for imported WSDL.", (Element)imports.get(i)));
                } else {
                    locationUri = namespaceAttr.getValue();
lbl28:
                    // 2 sources

                    try {
                        url = new URL(locationUri);
                        con = url.openConnection();
                        in = con.getInputStream();
                        try {
                            factory = DocumentBuilderFactory.newInstance();
                            factory.setNamespaceAware(true);
                            builder = factory.newDocumentBuilder();
                            document = builder.parse(in);
                            rootElement = document.getDocumentElement();
                            wsdl = new WSDL(rootElement);
                            if (wsdl.getSchemaProblems().size() > 0 || wsdl.getWSDLProblems().size() > 0) {
                                this.addProblem(this.createProblem("Problems importing WSDL: " + locationUri, (Element)imports.get(i)));
                                break block47;
                            }
                            this.wsdlsByNamespace.put(wsdl.targetNamespace, wsdl);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            this.addProblem(this.createProblem("Error while importing WSDL.", (Element)imports.get(i), ex));
                        }
                        in.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.addProblem(this.createProblem("Error while importing WSDL.", (Element)imports.get(i), e));
                    }
                }
            }
            ++i;
        }
        typesElementList = XMLUtilities.getElementsByTagNameNS((Element)wsdlElement, (String)"http://schemas.xmlsoap.org/wsdl/", (String)"types", (boolean)true);
        if (typesElementList.size() > 0) {
            typesElement = (Element)typesElementList.get(0);
            schemaElementList = XMLUtilities.getElementsByTagNameNS((Element)typesElement, (String)"http://www.w3.org/2001/XMLSchema", (String)"schema", (boolean)true);
            for (Object schemaElement : schemaElementList) {
                schema = new Schema((Element)schemaElement);
                this.schemas.add(schema);
            }
        }
        messageElementList = XMLUtilities.getElementsByTagNameNS((Element)wsdlElement, (String)"http://schemas.xmlsoap.org/wsdl/", (String)"message", (boolean)true);
        for (Element messageElement : messageElementList) {
            name = messageElement.getAttribute("name");
            message = new Message(name);
            partElementList = XMLUtilities.getElementsByTagNameNS((Element)messageElement, (String)"http://schemas.xmlsoap.org/wsdl/", (String)"part", (boolean)true);
            for (Element partElement : partElementList) {
                partName = partElement.getAttribute("name");
                elementAttr = partElement.getAttributeNode("element");
                if (elementAttr != null) {
                    elementItem = this.resolveElementItem(partElement, elementAttr.getValue());
                    if (elementItem == null) {
                        this.addProblem(this.createProblem("Could not resolve part element.", partElement));
                        continue;
                    }
                    part = new ElementPart(partName);
                    part.setElementItem(elementItem);
                    message.addPart(part);
                    continue;
                }
                typeAttr = partElement.getAttributeNode("type");
                if (typeAttr == null) {
                    this.addProblem(this.createProblem("Missing type or element attribute.", partElement));
                    continue;
                }
                type = this.resolveType(partElement, typeAttr.getValue());
                if (type == null) {
                    this.addProblem(this.createProblem("Could not resolve part type.", partElement));
                    continue;
                }
                part = new TypedPart(partName);
                part.setType(type);
                message.addPart(part);
            }
            this.messagesByName.put(name, message);
        }
        portTypeElementList = XMLUtilities.getElementsByTagNameNS((Element)wsdlElement, (String)"http://schemas.xmlsoap.org/wsdl/", (String)"portType", (boolean)true);
        for (Element portTypeElement : portTypeElementList) {
            portTypeName = portTypeElement.getAttribute("name");
            portType = new PortType(portTypeName);
            operationElementList = XMLUtilities.getElementsByTagNameNS((Element)portTypeElement, (String)"http://schemas.xmlsoap.org/wsdl/", (String)"operation", (boolean)true);
            for (Element operationElement : operationElementList) {
                operationName = operationElement.getAttribute("name");
                operation /* !! */  = null;
                children = XMLUtilities.getChildElementsNS((Element)operationElement, (String)"http://schemas.xmlsoap.org/wsdl/");
                if (children.size() < 1) {
                    this.addProblem(this.createProblem("No operation format specified: " + (String)portTypeName + "(" + operationName + ")", operationElement));
                    continue;
                }
                if (children.size() == 1) {
                    uo = new UnidirectionalOperation(operationName);
                    operationElementName = operationName;
                    child = (Element)children.get(0);
                    operationElementNameAttr = child.getAttributeNode("name");
                    if (operationElementNameAttr != null) {
                        operationElementName = operationElementNameAttr.getValue();
                    }
                    oe = null;
                    if (child.getLocalName().equals("input")) {
                        oe = new OperationElement("input");
                    } else if (child.getLocalName().equals("output")) {
                        oe = new OperationElement("output");
                    } else {
                        this.addProblem(this.createProblem("Unexpected operation element type: " + child.getLocalName(), child));
                        continue;
                    }
                    oe.setName(operationElementName);
                    message = this.resolveMessage(child, child.getAttribute("message"));
                    if (message == null) {
                        this.addProblem(this.createProblem("Could not resolve message type for operation element: " + child.getAttribute("message"), child));
                        continue;
                    }
                    oe.setMessage(message);
                    uo.setOperationElement(oe);
                    operation /* !! */  = uo;
                } else {
                    bo = new BidirectionalOperation(operationName);
                    inputElementName = operationName;
                    outputElementName = String.valueOf(operationName) + "Response";
                    oe = null;
                    firstElement = (Element)children.get(0);
                    offset = 2;
                    if (firstElement.getLocalName().equals("documentation")) {
                        firstElement = (Element)children.get(1);
                        ++offset;
                    }
                    if (firstElement.getLocalName().equals("input")) {
                        inputElementName = String.valueOf(inputElementName) + "Request";
                        oe = new OperationElement("input");
                        oe.setName(inputElementName);
                        bo.setType("request");
                        bo.setInputElement(oe);
                    } else if (firstElement.getLocalName().equals("output")) {
                        inputElementName = String.valueOf(inputElementName) + "Solicit";
                        oe = new OperationElement("output");
                        oe.setName(outputElementName);
                        bo.setType("solicit");
                        bo.setOutputElement(oe);
                    } else {
                        this.addProblem(this.createProblem("Unexpected operation element type: " + firstElement.getLocalName(), firstElement));
                        continue;
                    }
                    message = this.resolveMessage(firstElement, firstElement.getAttribute("message"));
                    if (message == null) {
                        this.addProblem(this.createProblem("Could not resolve message type for operation element: " + firstElement.getAttribute("message"), firstElement));
                        continue;
                    }
                    oe.setMessage(message);
                    secondElement = (Element)children.get(offset - 1);
                    if (secondElement.getLocalName().equals("input")) {
                        oe = new OperationElement("input");
                        oe.setName(inputElementName);
                        bo.setInputElement(oe);
                    } else if (secondElement.getLocalName().equals("output")) {
                        oe = new OperationElement("output");
                        oe.setName(outputElementName);
                        bo.setOutputElement(oe);
                    } else {
                        this.addProblem(this.createProblem("Unexpected operation element type: " + secondElement.getLocalName(), secondElement));
                        continue;
                    }
                    message = this.resolveMessage(secondElement, secondElement.getAttribute("message"));
                    if (message == null) {
                        this.addProblem(this.createProblem("Could not resolve message type for operation element: " + secondElement.getAttribute("message"), secondElement));
                        continue;
                    }
                    oe.setMessage(message);
                    i = offset;
                    while (i < children.size()) {
                        faultElement = (Element)children.get(i);
                        if (!faultElement.getLocalName().equals("fault")) {
                            this.addProblem(this.createProblem("Unexpected operation element type: " + faultElement.getLocalName(), faultElement));
                        } else {
                            oe = new OperationElement("fault");
                            message = this.resolveMessage(faultElement, faultElement.getAttribute("message"));
                            if (message == null) {
                                this.addProblem(this.createProblem("Could not resolve message type for fault element: " + faultElement.getAttribute("message"), faultElement));
                            } else {
                                oe.setMessage(message);
                                oe.setName(faultElement.getAttribute("name"));
                                bo.addFault(oe);
                            }
                        }
                        ++i;
                    }
                    operation /* !! */  = bo;
                }
                portType.addOperation(operation /* !! */ );
            }
            this.portTypesByName.put(portTypeName, portType);
        }
        bindingElementList = XMLUtilities.getElementsByTagNameNS((Element)wsdlElement, (String)"http://schemas.xmlsoap.org/wsdl/", (String)"binding", (boolean)true);
        for (Element bindingElement : bindingElementList) {
            bindingName = bindingElement.getAttribute("name");
            portType = this.resolvePortType(bindingElement, bindingElement.getAttribute("type"));
            binding = null;
            bindingExtensionElementList = XMLUtilities.getElementsByTagNameNS((Element)bindingElement, (String)"*", (String)"binding", (boolean)true);
            operationElementList = XMLUtilities.getElementsByTagNameNS((Element)bindingElement, (String)"http://schemas.xmlsoap.org/wsdl/", (String)"operation", (boolean)true);
            bindingExtensionElement = (Element)bindingExtensionElementList.get(0);
            if (bindingExtensionElement.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap/")) {
                binding = this.parseSoapBinding(bindingName, portType, bindingExtensionElement, operationElementList);
            }
            if (binding == null) continue;
            this.bindingsByName.put(bindingName, binding);
        }
        serviceElementList = XMLUtilities.getElementsByTagNameNS((Element)wsdlElement, (String)"http://schemas.xmlsoap.org/wsdl/", (String)"service", (boolean)true);
        for (Element serviceElement : serviceElementList) {
            serviceName = serviceElement.getAttribute("name");
            service = new Service(serviceName);
            portElementList = XMLUtilities.getElementsByTagNameNS((Element)serviceElement, (String)"http://schemas.xmlsoap.org/wsdl/", (String)"port", (boolean)true);
            for (Element portElement : portElementList) {
                portName = portElement.getAttribute("name");
                bindingName = portElement.getAttribute("binding");
                binding = this.resolveBinding(portElement, bindingName);
                port = new Port(portName);
                port.setBinding(binding);
                service.addPort(port);
            }
            this.servicesByName.put(serviceName, service);
        }
    }

    public List<WSDLProblem> getWSDLProblems() {
        return this.problems;
    }

    private void addProblem(WSDLProblem problem) {
        this.problems.add(problem);
    }

    public Binding parseSoapBinding(String bindingName, PortType portType, Element bindingExtensionElement, List<Element> operationElementList) {
        SoapBinding binding = new SoapBinding(bindingName);
        Attr transportAttr = bindingExtensionElement.getAttributeNode("transport");
        if (transportAttr != null && !"http://schemas.xmlsoap.org/soap/http".equals(transportAttr.getValue())) {
            this.addProblem(this.createProblem("Unsupported soap transport encountered: " + transportAttr.getValue(), bindingExtensionElement));
            return null;
        }
        Attr styleAttr = bindingExtensionElement.getAttributeNode("style");
        if (styleAttr != null) {
            binding.setStyle(styleAttr.getValue());
        }
        for (Element operationElement : operationElementList) {
            Operation operation = portType.getOperation(operationElement.getAttribute("name"));
            SoapBindingOperation bindingOperation = new SoapBindingOperation(operation);
            bindingOperation.setStyle(binding.getStyle());
            List operationExtensionElementList = XMLUtilities.getElementsByTagNameNS((Element)operationElement, (String)"http://schemas.xmlsoap.org/wsdl/soap/", (String)"operation", (boolean)true);
            if (operationExtensionElementList.size() > 0) {
                Element operationExtensionElement = (Element)operationExtensionElementList.get(0);
                Attr soapActionAttr = operationExtensionElement.getAttributeNode("soapAction");
                if (soapActionAttr != null) {
                    bindingOperation.setSoapAction(soapActionAttr.getValue());
                }
                if ((styleAttr = bindingExtensionElement.getAttributeNode("style")) != null) {
                    bindingOperation.setStyle(styleAttr.getValue());
                }
            }
            List operationItemElementList = XMLUtilities.getChildElementsNS((Element)operationElement, (String)WSDL_NAMESPACE);
            for (Element operationItemElement : operationItemElementList) {
                SoapBindingOperationElement bindingOperationElement;
                if (operationItemElement.getLocalName().equals("input")) {
                    bindingOperationElement = this.parseSoapBindingOperationItem(operationItemElement, operation);
                    bindingOperation.setInput(bindingOperationElement);
                    continue;
                }
                if (operationItemElement.getLocalName().equals("output")) {
                    bindingOperationElement = this.parseSoapBindingOperationItem(operationItemElement, operation);
                    bindingOperation.setOutput(bindingOperationElement);
                    continue;
                }
                String faultName = operationItemElement.getAttribute("name");
                String use = operationItemElement.getAttribute("use");
                SoapFault soapFault = new SoapFault(faultName, use);
                bindingOperation.addFault(soapFault);
            }
            binding.addOperation(bindingOperation);
        }
        return binding;
    }

    public SoapBindingOperationElement parseSoapBindingOperationItem(Element operationItemElement, Operation operation) {
        SoapBindingOperationElement bindingOperationItem = new SoapBindingOperationElement();
        List headerElementList = XMLUtilities.getElementsByTagNameNS((Element)operationItemElement, (String)"http://schemas.xmlsoap.org/wsdl/soap/", (String)"header", (boolean)true);
        for (Element headerElement : headerElementList) {
            String messageName;
            Message headerMessage = this.resolveMessage(headerElement, messageName = headerElement.getAttribute("message"));
            if (headerMessage == null) {
                this.addProblem(this.createProblem("Could not resolve header message: " + messageName, headerElement));
                return null;
            }
            String partName = headerElement.getAttribute("part");
            Part headerPart = headerMessage.getPart(partName);
            if (headerPart == null) {
                this.addProblem(this.createProblem("Could not locate part: " + partName + " in message: " + messageName, headerElement));
                return null;
            }
            String headerUse = headerElement.getAttribute("use");
            SoapHeader header = new SoapHeader(headerMessage, headerPart, headerUse);
            List headerFaultElementList = XMLUtilities.getElementsByTagNameNS((Element)headerElement, (String)"http://schemas.xmlsoap.org/wsdl/soap/", (String)"headerfault", (boolean)true);
            for (Element headerFaultElement : headerFaultElementList) {
                Message headerFaultMessage = this.resolveMessage(headerFaultElement, messageName = headerFaultElement.getAttribute("message"));
                if (headerFaultMessage == null) {
                    this.addProblem(this.createProblem("Could not resolve header fault message: " + messageName, headerFaultElement));
                    return null;
                }
                partName = headerFaultElement.getAttribute("part");
                Part headerFaultPart = headerFaultMessage.getPart(partName);
                if (headerFaultPart == null) {
                    this.addProblem(this.createProblem("Could not locate part: " + partName + " in message: " + messageName, headerFaultElement));
                    return null;
                }
                String headerFaultUse = headerFaultElement.getAttribute("use");
                SoapHeaderFault headerFault = new SoapHeaderFault(headerFaultMessage, headerFaultPart, headerFaultUse);
                header.addHeaderFault(headerFault);
            }
            bindingOperationItem.addHeader(header);
        }
        List bodyElementList = XMLUtilities.getElementsByTagNameNS((Element)operationItemElement, (String)"http://schemas.xmlsoap.org/wsdl/soap/", (String)"body", (boolean)true);
        if (bodyElementList.size() != 1) {
            this.addProblem(this.createProblem("Wrong number of soap body elements in " + operationItemElement.getLocalName() + " for operation: " + operation.getName(), operationItemElement));
            return null;
        }
        Element bodyElement = (Element)bodyElementList.get(0);
        SoapBody body = new SoapBody();
        body.setUsage(bodyElement.getAttribute("use"));
        OperationElement oe = null;
        oe = operation instanceof UnidirectionalOperation ? ((UnidirectionalOperation)operation).getOperationElement() : (operationItemElement.getLocalName().equals("input") ? ((BidirectionalOperation)operation).getInputElement() : ((BidirectionalOperation)operation).getOutputElement());
        System.out.println(oe);
        System.out.println(oe.getMessage());
        List<Part> parts = oe.getMessage().getParts();
        Attr partsAttr = bodyElement.getAttributeNode("parts");
        if (partsAttr != null) {
            String[] partNames;
            String[] stringArray = partNames = partsAttr.getValue().split(" ");
            int n = partNames.length;
            int n2 = 0;
            while (n2 < n) {
                String partName = stringArray[n2];
                Part part = oe.getMessage().getPart(partName);
                if (part == null) {
                    this.addProblem(this.createProblem("Could not locate part for soap body: " + partName, bodyElement));
                    return null;
                }
                body.addPart(part);
                ++n2;
            }
        } else {
            for (Part part : parts) {
                body.addPart(part);
            }
        }
        bindingOperationItem.setBody(body);
        return bindingOperationItem;
    }

    public ElementItem resolveElementItem(Element hostElement, String qName) {
        String[] baseParts = qName.split(":");
        String prefix = null;
        if (baseParts.length > 1) {
            prefix = baseParts[0];
        }
        String nameSpace = hostElement.lookupNamespaceURI(prefix);
        String partialName = baseParts[baseParts.length - 1];
        for (Schema schema : this.schemas) {
            ElementItem item = schema.resolveElementItem(nameSpace, partialName);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public Type resolveType(Element hostElement, String qName) {
        String[] baseParts = qName.split(":");
        String prefix = null;
        if (baseParts.length > 1) {
            prefix = baseParts[0];
        }
        String nameSpace = hostElement.lookupNamespaceURI(prefix);
        String partialName = baseParts[baseParts.length - 1];
        for (Schema schema : this.schemas) {
            Type type = schema.resolveType(nameSpace, partialName);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    public Message resolveMessage(Element hostElement, String qName) {
        String[] baseParts = qName.split(":");
        String prefix = null;
        if (baseParts.length > 1) {
            prefix = baseParts[0];
        }
        String nameSpace = hostElement.lookupNamespaceURI(prefix);
        String partialName = baseParts[baseParts.length - 1];
        return this.resolveMessage(nameSpace, partialName);
    }

    public Message resolveMessage(String uri, String name) {
        if (uri == null || uri.equals(this.targetNamespace)) {
            return this.messagesByName.get(name);
        }
        WSDL wsdl = this.wsdlsByNamespace.get(uri);
        if (wsdl == null) {
            return null;
        }
        return wsdl.getMessage(name);
    }

    public Message getMessage(String name) {
        return this.messagesByName.get(name);
    }

    public PortType resolvePortType(Element hostElement, String qName) {
        String[] baseParts = qName.split(":");
        String prefix = null;
        if (baseParts.length > 1) {
            prefix = baseParts[0];
        }
        String nameSpace = hostElement.lookupNamespaceURI(prefix);
        String partialName = baseParts[baseParts.length - 1];
        return this.resolvePortType(nameSpace, partialName);
    }

    public PortType resolvePortType(String uri, String name) {
        if (uri == null || uri.equals(this.targetNamespace)) {
            return this.portTypesByName.get(name);
        }
        WSDL wsdl = this.wsdlsByNamespace.get(uri);
        if (wsdl == null) {
            return null;
        }
        return wsdl.getPortType(name);
    }

    public PortType getPortType(String name) {
        return this.portTypesByName.get(name);
    }

    public Binding resolveBinding(Element hostElement, String qName) {
        String[] baseParts = qName.split(":");
        String prefix = null;
        if (baseParts.length > 1) {
            prefix = baseParts[0];
        }
        String nameSpace = hostElement.lookupNamespaceURI(prefix);
        String partialName = baseParts[baseParts.length - 1];
        return this.resolveBinding(nameSpace, partialName);
    }

    public Binding resolveBinding(String uri, String name) {
        if (uri == null || uri.equals(this.targetNamespace)) {
            return this.bindingsByName.get(name);
        }
        WSDL wsdl = this.wsdlsByNamespace.get(uri);
        if (wsdl == null) {
            return null;
        }
        return wsdl.getBinding(name);
    }

    public Binding getBinding(String name) {
        return this.bindingsByName.get(name);
    }

    public Service getService(String name) {
        return this.servicesByName.get(name);
    }

    public List<Service> getServices() {
        return new LinkedList<Service>(this.servicesByName.values());
    }

    public List<SchemaProblem> getSchemaProblems() {
        LinkedList<SchemaProblem> problems = new LinkedList<SchemaProblem>();
        for (Schema schema : this.schemas) {
            problems.addAll(schema.getProblems());
        }
        return problems;
    }

    private WSDLProblem createProblem(String message, Element source) {
        return this.createProblem(message, source, null);
    }

    private WSDLProblem createProblem(String message, Element source, Throwable t) {
        Object userData = source.getUserData("line_Number");
        int lineNumber = -1;
        if (userData != null && userData instanceof String) {
            try {
                lineNumber = Integer.parseInt((String)userData);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new WSDLProblem(message, lineNumber, t);
    }

    public static void main(String[] args) {
        File file;
        if (args.length < 1) {
            System.out.println("Usage: java WSDL file_path");
            System.exit(1);
        }
        if (!(file = new File(args[0])).exists()) {
            System.out.println("Usage: java WSDL file_path");
            System.exit(1);
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(file);
            Element rootElement = document.getDocumentElement();
            WSDL wsdl = new WSDL(rootElement);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

