/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.elements.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.vtp.desktop.model.core.internal.DesignWriter;
import org.eclipse.vtp.desktop.model.core.internal.design.Design;
import org.eclipse.vtp.framework.util.XMLWriter;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.vtp.desktop.model.elements.core";
    private static Activator plugin;
    private Properties localDialogMap = null;
    private File dialogFolder = null;
    private List<LocalDialogRecord> localDialogs = new ArrayList<LocalDialogRecord>();
    private List<LocalDialogListener> dialogListeners = new ArrayList<LocalDialogListener>();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        try {
            File propFile;
            File storageRoot = context.getDataFile("");
            this.dialogFolder = new File(storageRoot, "local_dialogs/");
            if (!this.dialogFolder.exists()) {
                this.dialogFolder.mkdirs();
            }
            if (!(propFile = new File(this.dialogFolder, "dialog_map.properties")).exists()) {
                this.localDialogMap = new Properties();
            } else {
                this.localDialogMap = new Properties();
                FileInputStream propIn = new FileInputStream(propFile);
                this.localDialogMap.load(propIn);
                ((InputStream)propIn).close();
            }
            for (Object obj : this.localDialogMap.keySet()) {
                String dialogId = (String)obj;
                this.localDialogs.add(new LocalDialogRecord(dialogId, this.localDialogMap.getProperty(dialogId), new File(this.dialogFolder, String.valueOf(dialogId) + ".xml").toURI().toURL()));
            }
            String[] fnames = this.dialogFolder.list();
            int i = 0;
            while (i < fnames.length) {
                System.err.println("local dialog: " + fnames[i]);
                ++i;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public LocalDialogRecord getLocalDialog(String id) {
        for (LocalDialogRecord record : this.localDialogs) {
            if (!record.getId().equals(id)) continue;
            return record;
        }
        return null;
    }

    public List<LocalDialogRecord> listLocalDialogs() {
        return Collections.unmodifiableList(this.localDialogs);
    }

    public void addLocalDialog(String name, Design model) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.getDOMImplementation().createDocument(null, "dialog-definition", null);
            Element rootElement = document.getDocumentElement();
            DesignWriter designWriter = new DesignWriter();
            designWriter.writeDesign(rootElement, model);
            String dialogId = model.getDesignId();
            File dialogTemplate = new File(this.dialogFolder, String.valueOf(dialogId) + ".xml");
            FileOutputStream baos = new FileOutputStream(dialogTemplate);
            TransformerFactory transfactory = TransformerFactory.newInstance();
            Transformer t = transfactory.newTransformer();
            t.setOutputProperty("method", "xml");
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            t.transform(new DOMSource(document), new XMLWriter((OutputStream)baos).toXMLResult());
            this.localDialogMap.setProperty(dialogId, name);
            this.localDialogs.add(new LocalDialogRecord(dialogId, this.localDialogMap.getProperty(dialogId), dialogTemplate.toURI().toURL()));
            File propFile = new File(this.dialogFolder, "dialog_map.properties");
            FileOutputStream propOut = new FileOutputStream(propFile);
            this.localDialogMap.store(propOut, "");
            ((OutputStream)propOut).close();
            this.fireDialogChange();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void removeLocalDialog(String id) {
        try {
            this.localDialogMap.remove(id);
            File propFile = new File(this.dialogFolder, "dialog_map.properties");
            FileOutputStream propOut = new FileOutputStream(propFile);
            this.localDialogMap.store(propOut, "");
            File dialogTemplate = new File(this.dialogFolder, String.valueOf(id) + ".xml");
            dialogTemplate.delete();
            LocalDialogRecord toRemove = null;
            for (LocalDialogRecord record : this.localDialogs) {
                if (!record.getId().equals(id)) continue;
                toRemove = record;
                break;
            }
            if (toRemove != null) {
                this.localDialogs.remove(toRemove);
            }
            this.fireDialogChange();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addListener(LocalDialogListener listener) {
        this.dialogListeners.remove(listener);
        this.dialogListeners.add(listener);
    }

    public void removeListener(LocalDialogListener listener) {
        this.dialogListeners.remove(listener);
    }

    public void fireDialogChange() {
        for (LocalDialogListener listener : this.dialogListeners) {
            listener.localDialogsChanged();
        }
    }

    public static interface LocalDialogListener {
        public void localDialogsChanged();
    }

    public class LocalDialogRecord {
        private String id;
        private String name;
        private URL templateURL;

        public LocalDialogRecord(String id, String name, URL templateURL) {
            this.id = id;
            this.name = name;
            this.templateURL = templateURL;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public URL getTemplateURL() {
            return this.templateURL;
        }
    }
}

