/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.elements.core.configuration;

import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.vtp.desktop.model.elements.core.configuration.FragmentConfigurationManager;
import org.eclipse.vtp.desktop.model.elements.core.configuration.OutputBinding;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ExitBinding {
    private String name = null;
    private FragmentConfigurationManager manager = null;
    private Map<String, OutputBinding> outputBindings = new TreeMap<String, OutputBinding>();

    public ExitBinding(FragmentConfigurationManager manager, String name) {
        this.manager = manager;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public OutputBinding getOutputBinding(String outputName) {
        return this.outputBindings.get(outputName);
    }

    public List<OutputBinding> getOutputBindings() {
        return new LinkedList<OutputBinding>(this.outputBindings.values());
    }

    public OutputBinding addOutputBinding(String outputName) {
        OutputBinding ret = this.outputBindings.get(outputName);
        if (ret == null) {
            ret = new OutputBinding(this.manager, outputName);
            this.outputBindings.put(outputName, ret);
        }
        return ret;
    }

    public void removeOutputBinding(OutputBinding binding) {
        this.outputBindings.remove(binding.getOutput());
    }

    public void clearOutputBindings() {
        this.outputBindings.clear();
    }

    public void readConfiguration(Element exitBindingElement) {
        NodeList outputBindingElementList = exitBindingElement.getElementsByTagName("output-binding");
        int i = 0;
        while (i < outputBindingElementList.getLength()) {
            Element outputBindingElement = (Element)outputBindingElementList.item(i);
            String outputName = outputBindingElement.getAttribute("name");
            OutputBinding outputBinding = new OutputBinding(this.manager, outputName);
            outputBinding.readConfiguration(outputBindingElement);
            this.outputBindings.put(outputName, outputBinding);
            ++i;
        }
    }

    public void writeConfiguration(Element exitBindingElement) {
        for (OutputBinding outputBinding : this.outputBindings.values()) {
            Element outputBindingElement = exitBindingElement.getOwnerDocument().createElement("output-binding");
            exitBindingElement.appendChild(outputBindingElement);
            outputBindingElement.setAttribute("name", outputBinding.getOutput());
            outputBinding.writeConfiguration(outputBindingElement);
        }
    }

    public void dumpContents(PrintStream out) {
        out.println("[Exit Binding] " + this.name);
        out.println("Output Bindings");
        for (OutputBinding outputBinding : this.outputBindings.values()) {
            outputBinding.dumpContents(out);
        }
    }
}

