/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.elements.core.configuration;

import java.io.PrintStream;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.model.elements.core.configuration.InputItem;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class InputBrandBinding {
    private ConfigurationManager manager = null;
    private IBrand brand = null;
    private InputItem value = null;
    private InputBrandBinding parentBinding = null;

    public InputBrandBinding(ConfigurationManager manager, IBrand brand) {
        this.manager = manager;
        this.brand = brand;
    }

    public IBrand getBrand() {
        return this.brand;
    }

    public void setParent(InputBrandBinding parentBinding) {
        this.parentBinding = parentBinding;
    }

    public boolean hasParent() {
        return this.parentBinding != null;
    }

    public boolean isInherited() {
        return this.value == null;
    }

    public InputItem getValue() {
        if (this.value == null && this.parentBinding != null) {
            return this.parentBinding.getValue();
        }
        return this.value;
    }

    public void setValue(InputItem value) {
        this.value = value;
    }

    public void readConfiguration(Element brandBindingElement) {
        NodeList bindingItemElementList = brandBindingElement.getElementsByTagName("input-item");
        if (bindingItemElementList.getLength() > 0) {
            Element bindingItemElement = (Element)bindingItemElementList.item(0);
            InputItem bindingItem = new InputItem();
            bindingItem.readConfiguration(bindingItemElement);
            this.value = bindingItem;
        }
    }

    public void writeConfiguration(Element brandBindingElement) {
        if (this.value != null) {
            Element bindingItemElement = brandBindingElement.getOwnerDocument().createElement("input-item");
            brandBindingElement.appendChild(bindingItemElement);
            this.value.writeConfiguration(bindingItemElement);
        }
    }

    public void dumpContents(PrintStream out) {
        out.println("[IBrand Binding] " + this.brand.getName() + "(" + this.brand.getId() + ")");
        this.value.dumpContents(out);
    }
}

