/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.elements.core.configuration;

import java.io.PrintStream;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.model.elements.core.configuration.OutputItem;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OutputBrandBinding {
    private ConfigurationManager manager = null;
    private IBrand brand = null;
    private OutputItem value = null;
    private OutputBrandBinding parentBinding = null;

    public OutputBrandBinding(ConfigurationManager manager, IBrand brand) {
        this.manager = manager;
        this.brand = brand;
    }

    public IBrand getBrand() {
        return this.brand;
    }

    public void setParent(OutputBrandBinding parentBinding) {
        this.parentBinding = parentBinding;
    }

    public boolean hasParent() {
        return this.parentBinding != null;
    }

    public boolean isInherited() {
        return this.value == null;
    }

    public OutputItem getValue() {
        if (this.value == null && this.parentBinding != null) {
            return this.parentBinding.getValue();
        }
        return this.value;
    }

    public void setValue(OutputItem value) {
        this.value = value;
    }

    public void readConfiguration(Element brandBindingElement) {
        NodeList itemList = brandBindingElement.getElementsByTagName("output-item");
        if (itemList.getLength() > 0) {
            Element itemElement = (Element)itemList.item(0);
            this.value = new OutputItem(XMLUtilities.getElementTextDataNoEx((Element)itemElement, (boolean)true));
        }
    }

    public void writeConfiguration(Element brandBindingElement) {
        if (this.value != null) {
            Element itemElement = brandBindingElement.getOwnerDocument().createElement("output-item");
            brandBindingElement.appendChild(itemElement);
            itemElement.setTextContent(this.value.getValue());
        }
    }

    public void dumpContents(PrintStream out) {
        out.println("[IBrand Binding] " + this.brand.getName() + "(" + this.brand.getId() + ")");
        out.println("Value " + (this.value == null ? "NULL" : this.value.getValue()));
    }
}

