/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.elements.core.export;

import org.eclipse.vtp.desktop.export.IConfigurationExporter;
import org.eclipse.vtp.desktop.export.IFlowElement;
import org.eclipse.vtp.framework.common.configurations.DispatchConfiguration;
import org.eclipse.vtp.framework.common.configurations.VariableMappingConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IncludeConfigurationExporter
implements IConfigurationExporter {
    public void exportConfiguration(IFlowElement flowElement, Element actionElement) {
        DispatchConfiguration config = new DispatchConfiguration();
        config.setTargetProcessURI(flowElement.getName());
        Element includeManagedConfig = null;
        NodeList managedConfigList = flowElement.getConfiguration().getElementsByTagName("managed-config");
        int i = 0;
        while (includeManagedConfig == null && i < managedConfigList.getLength()) {
            Element element = (Element)managedConfigList.item(i);
            if ("org.eclipse.vtp.configuration.include".equals(element.getAttribute("type"))) {
                includeManagedConfig = element;
            }
            ++i;
        }
        if (includeManagedConfig != null) {
            int j;
            NodeList inputBindingList = includeManagedConfig.getElementsByTagName("input-binding");
            int i2 = 0;
            while (i2 < inputBindingList.getLength()) {
                Element inputBinding = (Element)inputBindingList.item(i2);
                VariableMappingConfiguration vmc = new VariableMappingConfiguration();
                NodeList brandBindingList = inputBinding.getElementsByTagName("brand-binding");
                j = 0;
                while (j < brandBindingList.getLength()) {
                    Element brandBinding = (Element)brandBindingList.item(j);
                    if ("Default".equals(brandBinding.getAttribute("name"))) {
                        Element inputItem = (Element)brandBinding.getElementsByTagName("input-item").item(0);
                        String type = inputItem.getAttribute("type");
                        String value = inputItem.getTextContent().trim();
                        if ("VARIABLE".equalsIgnoreCase(type)) {
                            vmc.setVariableValue(value);
                        } else if ("EXPRESSION".equalsIgnoreCase(type)) {
                            vmc.setExpressionValue(value, "JavaScript");
                        } else if ("STATIC".equalsIgnoreCase(type)) {
                            vmc.setStaticValue(value);
                        } else {
                            vmc.setNoValue();
                        }
                    }
                    ++j;
                }
                config.setVariableMapping(inputBinding.getAttribute("name"), vmc);
                ++i2;
            }
            NodeList exitBindingList = includeManagedConfig.getElementsByTagName("exit-binding");
            int i3 = 0;
            while (i3 < exitBindingList.getLength()) {
                Element exitBinding = (Element)exitBindingList.item(i3);
                NodeList outputBindingList = exitBinding.getElementsByTagName("output-binding");
                j = 0;
                while (j < outputBindingList.getLength()) {
                    Element outputBinding = (Element)outputBindingList.item(j);
                    NodeList brandBindingList = outputBinding.getElementsByTagName("brand-binding");
                    int k = 0;
                    while (k < brandBindingList.getLength()) {
                        Element brandBinding = (Element)brandBindingList.item(k);
                        if ("Default".equals(brandBinding.getAttribute("name"))) {
                            Element outputItem = (Element)brandBinding.getElementsByTagName("output-item").item(0);
                            config.setOutgoingDataValue(exitBinding.getAttribute("name"), outputBinding.getAttribute("name"), outputItem.getTextContent().trim());
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i3;
            }
        }
        Element configElement = actionElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/common/configurations", "common:dispatch");
        config.save(configElement);
        actionElement.appendChild(configElement);
    }

    public String getActionId(IFlowElement flowElement) {
        return "org.eclipse.vtp.framework.common.actions.include";
    }

    public String getDefaultPath(IFlowElement flowElement) {
        return null;
    }

    public String translatePath(IFlowElement flowElement, String uiPath) {
        return uiPath;
    }

    public String getTargetId(IFlowElement flowElement, Element afterTransitionElement) {
        return flowElement.getDefaultTargetId(afterTransitionElement);
    }

    public boolean isEntryPoint(IFlowElement flowElement) {
        return false;
    }
}

