/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.elements.core.internal;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.eclipse.swt.graphics.Image;
import org.eclipse.vtp.desktop.model.core.IDesignDocument;
import org.eclipse.vtp.desktop.model.core.IWorkflowEntry;
import org.eclipse.vtp.desktop.model.core.IWorkflowExit;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.IWorkflowReference;
import org.eclipse.vtp.desktop.model.core.WorkflowCore;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.model.core.design.IDesign;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowTraversalHelper;
import org.eclipse.vtp.desktop.model.core.internal.design.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignElement;
import org.eclipse.vtp.desktop.model.core.internal.design.ElementResolutionVisitor;
import org.eclipse.vtp.desktop.model.elements.core.configuration.FragmentConfigurationManager;
import org.w3c.dom.Element;

public class ApplicationFragmentElement
extends DesignElement
implements IWorkflowReference {
    public static final String ELEMENT_TYPE = "org.eclipse.vtp.desktop.model.elements.core.include";
    private List<ConnectorRecord> connectorRecords = new ArrayList<ConnectorRecord>();
    private String fragmentId;
    private String entryId;
    private boolean missingModelMode = true;
    private IWorkflowProject workflowProject = null;

    public ApplicationFragmentElement(String fragmentId, String name) {
        super(name);
        this.getProperties().setProperty("instanceId", fragmentId);
        this.setFragmentId(fragmentId, true);
    }

    public ApplicationFragmentElement(String id, String name, Properties properties) {
        super(id, name, properties);
        this.setFragmentId(properties.getProperty("instanceId"), Boolean.parseBoolean(properties.getProperty("followExternalReferences", "true")));
    }

    public String getType() {
        return ELEMENT_TYPE;
    }

    public void setFragmentId(String fragmentId, boolean followExternalReferences) {
        this.fragmentId = fragmentId;
        if (followExternalReferences) {
            this.workflowProject = WorkflowCore.getDefault().getWorkflowModel().getWorkflowProject(fragmentId);
            if (this.workflowProject != null) {
                this.missingModelMode = false;
            }
        }
    }

    private void setEntry(String entryId) {
        this.entryId = entryId;
        if (!this.missingModelMode) {
            List<ConnectorRecord> oldCRs = this.connectorRecords;
            this.connectorRecords = new LinkedList<ConnectorRecord>();
            IWorkflowEntry entry = null;
            entry = entryId == null || entryId.equals("") ? this.workflowProject.getWorkflowEntryByName("Begin") : this.workflowProject.getWorkflowEntry(entryId);
            if (entry != null) {
                ArrayList<IDesignDocument> workingCopies = new ArrayList<IDesignDocument>();
                workingCopies.add(this.getDesign().getDocument());
                WorkflowTraversalHelper wth = new WorkflowTraversalHelper(this.workflowProject, workingCopies);
                List exitPoints = wth.getDownStreamWorkflowExits(entry);
                block0: for (IWorkflowExit exit : exitPoints) {
                    for (ConnectorRecord oldCR : oldCRs) {
                        if (!oldCR.getName().equals(exit.getName()) || !oldCR.getType().equals((Object)(exit.getType().equals("NORMAL") ? IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT : IDesignElementConnectionPoint.ConnectionPointType.ERROR_POINT))) continue;
                        this.connectorRecords.add(oldCR);
                        continue block0;
                    }
                    ConnectorRecord cr = new ConnectorRecord((DesignElement)this, exit.getName(), exit.getType().equals("NORMAL") ? IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT : IDesignElementConnectionPoint.ConnectionPointType.ERROR_POINT);
                    this.connectorRecords.add(cr);
                }
                for (ConnectorRecord oldCR : oldCRs) {
                    if (this.connectorRecords.contains(oldCR) || oldCR.getDesignConnector() == null) continue;
                    this.getDesign().removeDesignConnector(oldCR.getDesignConnector());
                }
            }
        }
    }

    public String getFragmentId() {
        return this.fragmentId;
    }

    public boolean isModelPresent() {
        return !this.missingModelMode;
    }

    public IWorkflowProject getReferencedModel() {
        return this.workflowProject;
    }

    public IDesignElementConnectionPoint getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        if (this.missingModelMode) {
            ConnectorRecord cr = new ConnectorRecord((DesignElement)this, recordName, recordName.startsWith("error.") ? IDesignElementConnectionPoint.ConnectionPointType.ERROR_POINT : IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT);
            this.connectorRecords.add(cr);
            return cr;
        }
        return null;
    }

    public List<IDesignElementConnectionPoint> getConnectorRecords() {
        return new LinkedList<ConnectorRecord>(this.connectorRecords);
    }

    public List<IDesignElementConnectionPoint> getConnectorRecords(IDesignElementConnectionPoint.ConnectionPointType ... types) {
        ArrayList<IDesignElementConnectionPoint> ret = new ArrayList<IDesignElementConnectionPoint>();
        for (ConnectorRecord cr : this.connectorRecords) {
            if (cr.getType().isSet(IDesignElementConnectionPoint.ConnectionPointType.getFlagSet((IDesignElementConnectionPoint.ConnectionPointType[])types))) {
                // empty if block
            }
            ret.add((IDesignElementConnectionPoint)cr);
        }
        return ret;
    }

    public void addConfigurationManager(ConfigurationManager manager) {
        super.addConfigurationManager(manager);
        if (manager.getType().equals("org.eclipse.vtp.configuration.include")) {
            IWorkflowEntry entry;
            FragmentConfigurationManager fragmentConfigurationManager = (FragmentConfigurationManager)manager;
            String currentEntry = fragmentConfigurationManager.getEntryId();
            if ((currentEntry == null || currentEntry.equals("")) && (entry = this.workflowProject.getWorkflowEntryByName("Begin Fragment")) != null) {
                currentEntry = entry.getId();
                fragmentConfigurationManager.setEntryId(currentEntry);
            }
            this.setEntry(currentEntry);
        }
    }

    public void commitConfigurationChanges(ConfigurationManager manager) {
        super.commitConfigurationChanges(manager);
        if (manager.getType().equals("org.eclipse.vtp.configuration.include")) {
            this.setEntry(((FragmentConfigurationManager)manager).getEntryId());
        }
    }

    public void readCustomConfiguration(Element configuration) {
    }

    public void writeCustomConfiguration(Element customElement) {
    }

    public boolean acceptsConnector(IDesignElement origin) {
        return true;
    }

    public String getTypeName() {
        return "Application Fragment";
    }

    public Image getIcon() {
        return null;
    }

    public void resolve(ElementResolutionVisitor resolutionVisitor) {
    }

    public boolean hasConnectors() {
        return !this.connectorRecords.isEmpty();
    }

    public boolean canBeContainedBy(IDesign design) {
        return design.equals(design.getDocument().getMainDesign());
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this;
        }
        return null;
    }

    public String getTargetId() {
        return this.fragmentId;
    }

    public String getEntryId() {
        return this.entryId;
    }
}

