/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.elements.core.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.swt.graphics.Image;
import org.eclipse.vtp.desktop.model.core.design.IDesign;
import org.eclipse.vtp.desktop.model.core.design.IDesignComponent;
import org.eclipse.vtp.desktop.model.core.design.IDesignConnector;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.design.ModelListener;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.core.internal.DesignDocument;
import org.eclipse.vtp.desktop.model.core.internal.design.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.internal.design.Design;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignElement;
import org.eclipse.vtp.desktop.model.elements.core.IDialogExit;
import org.w3c.dom.Element;

public class DialogElement
extends DesignElement
implements ModelListener {
    public static final String ELEMENT_TYPE = "org.eclipse.vtp.desktop.model.elements.core.dialog";
    private boolean hasConnectors = false;
    private List<ConnectorRecord> connectorRecords = new ArrayList<ConnectorRecord>();
    private Map<String, NameWatcher> watchers = new HashMap<String, NameWatcher>();
    private IDesign dialogDesign = null;

    public DialogElement(String name) {
        super(name);
    }

    public DialogElement(String id, String name, Properties properties) {
        super(id, name, properties);
    }

    public String getType() {
        return ELEMENT_TYPE;
    }

    public void resolve() {
        this.dialogDesign = this.getDesign().getDocument().getDialogDesign(this.getId());
        this.dialogDesign.addListener((ModelListener)this);
        for (IDesignElement designElement : this.dialogDesign.getDesignElements()) {
            IDialogExit exit = (IDialogExit)designElement.getAdapter(IDialogExit.class);
            if (exit == null) continue;
            IDesignElementConnectionPoint.ConnectionPointType type = exit.getType();
            ConnectorRecord connectorRecord = new ConnectorRecord((DesignElement)designElement, designElement.getName(), type);
            this.connectorRecords.add(connectorRecord);
            NameWatcher nameWatcher = new NameWatcher(connectorRecord);
            designElement.addPropertyListener((PropertyChangeListener)nameWatcher);
            this.watchers.put(designElement.getId(), nameWatcher);
            this.hasConnectors = true;
        }
    }

    public IDesignElementConnectionPoint getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List<IDesignElementConnectionPoint> getConnectorRecords() {
        return new LinkedList<ConnectorRecord>(this.connectorRecords);
    }

    public List<IDesignElementConnectionPoint> getConnectorRecords(IDesignElementConnectionPoint.ConnectionPointType ... types) {
        LinkedList<IDesignElementConnectionPoint> ret = new LinkedList<IDesignElementConnectionPoint>();
        for (ConnectorRecord cr : this.connectorRecords) {
            if (!cr.getType().isSet(IDesignElementConnectionPoint.ConnectionPointType.getFlagSet((IDesignElementConnectionPoint.ConnectionPointType[])types))) continue;
            ret.add((IDesignElementConnectionPoint)cr);
        }
        return ret;
    }

    public void readCustomConfiguration(Element configuration) {
    }

    public void writeCustomConfiguration(Element customElement) {
    }

    public boolean acceptsConnector(IDesignElement origin) {
        return true;
    }

    public String getTypeName() {
        return "Dialog";
    }

    public Image getIcon() {
        return null;
    }

    protected void setId(String id) {
        super.setId(id);
        ((Design)this.dialogDesign).setDesignId(id);
    }

    public boolean hasConnectors() {
        return this.hasConnectors;
    }

    public void nameChanged(IDesign model) {
        this.setName(model.getName());
    }

    public void componentAdded(IDesign model, IDesignComponent component) {
        DesignElement designElement;
        IDialogExit exit;
        if (component instanceof DesignElement && (exit = (IDialogExit)(designElement = (DesignElement)component).getAdapter(IDialogExit.class)) != null) {
            IDesignElementConnectionPoint.ConnectionPointType type = exit.getType();
            ConnectorRecord connectorRecord = new ConnectorRecord(designElement, designElement.getName(), type);
            this.connectorRecords.add(connectorRecord);
            NameWatcher nameWatcher = new NameWatcher(connectorRecord);
            designElement.addPropertyListener((PropertyChangeListener)nameWatcher);
            this.watchers.put(designElement.getId(), nameWatcher);
            this.hasConnectors = true;
        }
    }

    public void componentRemoved(IDesign model, IDesignComponent component) {
        DesignElement designElement;
        IDialogExit exit;
        if (component instanceof DesignElement && (exit = (IDialogExit)(designElement = (DesignElement)component).getAdapter(IDialogExit.class)) != null) {
            NameWatcher nameWatcher = this.watchers.remove(designElement.getId());
            designElement.removePropertyListener((PropertyChangeListener)nameWatcher);
            this.connectorRecords.remove(nameWatcher.watched);
            if (nameWatcher.watched.getDesignConnector() != null) {
                IDesignConnector connector = nameWatcher.watched.getDesignConnector();
                connector.removeConnectionPoint((IDesignElementConnectionPoint)nameWatcher.watched);
                if (connector.getConnectionPoints().size() == 0) {
                    this.getDesign().removeDesignConnector(connector);
                }
            }
        }
    }

    public List<Variable> getOutgoingVariables(String exitPoint, boolean localOnly) {
        System.out.println("getting dialog variables for exit: " + exitPoint);
        IDesign dialogDesign = this.getDesign().getDocument().getDialogDesign(this.getId());
        List elements = dialogDesign.getDesignElements();
        for (IDesignElement designElement : elements) {
            IDialogExit dialogExit = (IDialogExit)designElement.getAdapter(IDialogExit.class);
            if (dialogExit == null) continue;
            System.out.println("found dialog exit: " + designElement.getName());
            if (!designElement.getName().equals(exitPoint)) continue;
            return dialogDesign.getVariablesFor(designElement, true);
        }
        return Collections.emptyList();
    }

    public void orientationChanged(IDesign model) {
    }

    public void paperSizeChanged(IDesign model) {
    }

    public boolean canBeContainedBy(IDesign design) {
        return design.equals(design.getDocument().getMainDesign());
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this;
        }
        return null;
    }

    public void delete() {
        ((DesignDocument)this.getDesign().getDocument()).removeDialogDesign(this.getId());
        super.delete();
    }

    private class NameWatcher
    implements PropertyChangeListener {
        ConnectorRecord watched = null;

        public NameWatcher(ConnectorRecord watched) {
            this.watched = watched;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DesignElement designElement;
            IDialogExit exit;
            if (evt.getPropertyName().equals("model.element.name")) {
                this.watched.setName((String)evt.getNewValue());
            } else if (evt.getPropertyName().equals("PROP_EXIT_TYPE") && (exit = (IDialogExit)(designElement = (DesignElement)evt.getSource()).getAdapter(IDialogExit.class)) != null) {
                this.watched.setType(exit.getType());
            }
        }
    }
}

