/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.elements.core.internal;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.internal.design.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignElement;
import org.eclipse.vtp.desktop.model.elements.core.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.w3c.dom.Element;

public class MissingCustomIntegrationInformationProvider
extends PrimitiveInformationProvider {
    private Element configuration = null;
    private List<ConnectorRecord> connectorRecords = new LinkedList<ConnectorRecord>();

    public MissingCustomIntegrationInformationProvider(PrimitiveElement element) {
        super(element);
    }

    @Override
    public boolean acceptsConnector(IDesignElement origin) {
        return true;
    }

    @Override
    public ConnectorRecord getConnectorRecord(String recordName) {
        ConnectorRecord cr = null;
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord temp = this.connectorRecords.get(i);
            if (temp.getName().equals(recordName)) {
                cr = temp;
                break;
            }
            ++i;
        }
        if (cr == null) {
            cr = new ConnectorRecord((DesignElement)this.getElement(), recordName, IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT);
            this.connectorRecords.add(cr);
        }
        return cr;
    }

    @Override
    public List<ConnectorRecord> getConnectorRecords() {
        return this.connectorRecords;
    }

    @Override
    public List<ConnectorRecord> getConnectorRecords(IDesignElementConnectionPoint.ConnectionPointType ... types) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getType().isSet(IDesignElementConnectionPoint.ConnectionPointType.getFlagSet((IDesignElementConnectionPoint.ConnectionPointType[])types))) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    @Override
    public boolean hasConnectors() {
        return true;
    }

    @Override
    public void readConfiguration(Element configuration) {
        this.configuration = configuration;
    }

    @Override
    public void writeConfiguration(Element configuration) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(this.configuration), new DOMResult(configuration));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }
}

