/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.elements.core.internal;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.vtp.desktop.core.Activator;
import org.eclipse.vtp.desktop.model.elements.core.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.desktop.model.elements.core.internal.ScriptedPrimitiveInformationProvider;
import org.eclipse.vtp.desktop.model.elements.core.internal.SecurableScriptedPrimitiveInformationProvider;
import org.eclipse.vtp.desktop.model.elements.core.internal.views.PalletItemFilter;
import org.osgi.framework.Bundle;

public class PrimitiveElementManager {
    public static String primitiveExtensionPointId = "org.eclipse.vtp.desktop.model.elements.core.primitiveElement";
    private static PrimitiveElementManager instance = new PrimitiveElementManager();
    private Map<String, PrimitiveElementTemplate> primitiveTypes = new HashMap<String, PrimitiveElementTemplate>();

    public static PrimitiveElementManager getDefault() {
        return instance;
    }

    public PrimitiveElementManager() {
        IConfigurationElement[] primitiveExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(primitiveExtensionPointId);
        int i = 0;
        while (i < primitiveExtensions.length) {
            IConfigurationElement[] scriptElements;
            PrimitiveElementTemplate template = null;
            String id = primitiveExtensions[i].getAttribute("id");
            String name = primitiveExtensions[i].getAttribute("name");
            String iconPath = primitiveExtensions[i].getAttribute("icon");
            boolean uniqueName = false;
            String uniqueNameString = primitiveExtensions[i].getAttribute("unique-name");
            if (uniqueNameString != null) {
                uniqueName = Boolean.parseBoolean(uniqueNameString);
            }
            Bundle contributor = Platform.getBundle((String)primitiveExtensions[i].getContributor().getName());
            PalletItemFilter filter = null;
            String filterName = primitiveExtensions[i].getAttribute("filter");
            if (filterName != null) {
                try {
                    Class filterClass = contributor.loadClass(filterName);
                    filter = (PalletItemFilter)filterClass.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (iconPath != null) {
                Activator.getDefault().getImageRegistry().put(id, ImageDescriptor.createFromURL((URL)contributor.getEntry(iconPath)));
            }
            if ((scriptElements = primitiveExtensions[i].getChildren("information_script")).length < 1) {
                scriptElements = primitiveExtensions[i].getChildren("information_provider");
                if (scriptElements.length >= 1) {
                    String className = scriptElements[0].getAttribute("class");
                    try {
                        Class providerClass = contributor.loadClass(className);
                        template = new ImplementedClassTemplate(id, name, filter, providerClass);
                        break block11;
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                block11: {
                    template = new ScriptedTemplate(id, name, filter, scriptElements[0]);
                }
                this.primitiveTypes.put(template.getId(), template);
            }
            ++i;
        }
    }

    public PrimitiveElementTemplate getElementTemplate(String typeId) {
        return this.primitiveTypes.get(typeId);
    }

    public class ImplementedClassTemplate
    extends PrimitiveElementTemplate {
        Class<PrimitiveInformationProvider> informationProviderClass;

        public ImplementedClassTemplate(String id, String name, PalletItemFilter filter, Class<PrimitiveInformationProvider> informationProviderClass) {
            super(id, name, filter);
            this.informationProviderClass = informationProviderClass;
        }

        @Override
        public PrimitiveInformationProvider getInformationProviderInstance(PrimitiveElement element) {
            try {
                Constructor<PrimitiveInformationProvider> con = this.informationProviderClass.getConstructor(PrimitiveElement.class);
                return con.newInstance(new Object[]{element});
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public abstract class PrimitiveElementTemplate {
        private String id;
        private String name;
        private PalletItemFilter filter = null;

        public PrimitiveElementTemplate(String id, String name, PalletItemFilter filter) {
            this.id = id;
            this.name = name;
            this.filter = filter;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public PalletItemFilter getFilter() {
            return this.filter;
        }

        public abstract PrimitiveInformationProvider getInformationProviderInstance(PrimitiveElement var1);
    }

    public class ScriptedTemplate
    extends PrimitiveElementTemplate {
        private IConfigurationElement scriptElement;

        public ScriptedTemplate(String id, String name, PalletItemFilter filter, IConfigurationElement scriptElement) {
            super(id, name, filter);
            this.scriptElement = scriptElement;
        }

        @Override
        public PrimitiveInformationProvider getInformationProviderInstance(PrimitiveElement element) {
            ScriptedPrimitiveInformationProvider ret = null;
            ret = this.scriptElement.getAttribute("securable") == null || !Boolean.parseBoolean(this.scriptElement.getAttribute("securable")) ? new ScriptedPrimitiveInformationProvider(element) : new SecurableScriptedPrimitiveInformationProvider(element);
            ret.init(this.scriptElement);
            return ret;
        }
    }
}

