/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.elements.core.internal.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.vtp.desktop.model.core.design.IDesign;
import org.eclipse.vtp.desktop.model.elements.core.Activator;
import org.eclipse.vtp.desktop.model.elements.core.internal.DialogElementFactory;
import org.eclipse.vtp.desktop.model.elements.core.internal.DialogElementManager;
import org.eclipse.vtp.desktop.views.pallet.PalletItem;
import org.eclipse.vtp.desktop.views.pallet.PalletItemObserver;
import org.eclipse.vtp.desktop.views.pallet.PalletItemProvider;

public class DialogPalletProvider
implements PalletItemProvider,
Activator.LocalDialogListener {
    List<PalletItem> primitiveItems = new ArrayList<PalletItem>();
    List<PalletItemObserver> observers = new ArrayList<PalletItemObserver>();

    public DialogPalletProvider() {
        Activator.getDefault().addListener(this);
        this.loadItems();
    }

    private void loadItems() {
        IConfigurationElement[] primitiveExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(DialogElementManager.dialogExtensionPointId);
        int i = 0;
        while (i < primitiveExtensions.length) {
            String id = primitiveExtensions[i].getAttribute("id");
            String name = primitiveExtensions[i].getAttribute("name");
            this.primitiveItems.add(new PalletItem(name, null, new DialogElementFactory(), id){

                public boolean canBeContainedBy(IDesign design) {
                    return design.equals(design.getDocument().getMainDesign());
                }
            });
            ++i;
        }
        List<Activator.LocalDialogRecord> localDialogs = Activator.getDefault().listLocalDialogs();
        for (Activator.LocalDialogRecord record : localDialogs) {
            this.primitiveItems.add(new PalletItem(record.getName(), null, new DialogElementFactory(), record.getId()){

                public boolean canBeContainedBy(IDesign design) {
                    return design.equals(design.getDocument().getMainDesign());
                }
            });
        }
    }

    public String getName() {
        return "Dialogs";
    }

    public List<PalletItem> getPalletItems() {
        return this.primitiveItems;
    }

    public int getRanking() {
        return 20;
    }

    public void createMenu(IAdaptable container, IMenuManager manager, final PalletItem[] selectedItems) {
        if (selectedItems.length == 1 && Activator.getDefault().getLocalDialog((String)selectedItems[0].getData()) != null) {
            manager.add((IAction)new Action("Delete Dialog..."){

                public void run() {
                    Activator.getDefault().removeLocalDialog((String)selectedItems[0].getData());
                }
            });
        }
    }

    public void addPalletItemObserver(PalletItemObserver observer) {
        this.observers.remove(observer);
        this.observers.add(observer);
    }

    public void removePalletItemObserver(PalletItemObserver observer) {
        this.observers.remove(observer);
    }

    public void fireChange() {
        for (PalletItemObserver observer : this.observers) {
            observer.palletItemsChanged();
        }
    }

    @Override
    public void localDialogsChanged() {
        this.primitiveItems.clear();
        this.loadItems();
        this.fireChange();
    }
}

