/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.elements.core.internal.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.vtp.desktop.core.Activator;
import org.eclipse.vtp.desktop.model.core.design.IDesign;
import org.eclipse.vtp.desktop.model.core.internal.design.ElementFactory;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElementFactory;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElementManager;
import org.eclipse.vtp.desktop.model.elements.core.internal.views.PalletItemFilter;
import org.eclipse.vtp.desktop.views.pallet.PalletItem;
import org.eclipse.vtp.desktop.views.pallet.PalletItemObserver;
import org.eclipse.vtp.desktop.views.pallet.PalletItemProvider;
import org.osgi.framework.Bundle;

public class PrimitivePalletProvider
implements PalletItemProvider {
    List<PalletItem> primitiveItems = new ArrayList<PalletItem>();

    public PrimitivePalletProvider() {
        IConfigurationElement[] primitiveExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(PrimitiveElementManager.primitiveExtensionPointId);
        int i = 0;
        while (i < primitiveExtensions.length) {
            String id = primitiveExtensions[i].getAttribute("id");
            String name = primitiveExtensions[i].getAttribute("name");
            boolean popOnDrop = false;
            String popOnDropString = primitiveExtensions[i].getAttribute("pop-on-drop");
            if (popOnDropString != null) {
                popOnDrop = Boolean.parseBoolean(popOnDropString);
            }
            Bundle contributor = Platform.getBundle((String)primitiveExtensions[i].getContributor().getName());
            String className = primitiveExtensions[i].getAttribute("filter");
            if (className != null) {
                try {
                    Class filterClass = contributor.loadClass(className);
                    final PalletItemFilter filter = (PalletItemFilter)filterClass.newInstance();
                    PalletItem palletItem = new PalletItem(name, Activator.getDefault().getImageRegistry().get(id), new PrimitiveElementFactory(), id){

                        public boolean canBeContainedBy(IDesign container) {
                            return filter.canBeContainedBy(container);
                        }
                    };
                    palletItem.setPopOnDrop(popOnDrop);
                    this.primitiveItems.add(palletItem);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                PalletItem palletItem = new PalletItem(name, Activator.getDefault().getImageRegistry().get(id), (ElementFactory)new PrimitiveElementFactory(), (Object)id);
                palletItem.setPopOnDrop(popOnDrop);
                this.primitiveItems.add(palletItem);
            }
            ++i;
        }
    }

    public String getName() {
        return "Common";
    }

    public List<PalletItem> getPalletItems() {
        return this.primitiveItems;
    }

    public int getRanking() {
        return 10;
    }

    public void createMenu(IAdaptable container, IMenuManager manager, PalletItem[] selectedItems) {
    }

    public void addPalletItemObserver(PalletItemObserver observer) {
    }

    public void removePalletItemObserver(PalletItemObserver observer) {
    }
}

