/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.interactive.core.configuration.generic;

import java.io.PrintStream;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.vtp.desktop.model.core.branding.BrandManager;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationException;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.model.core.design.IDesign;
import org.eclipse.vtp.desktop.model.interactive.core.IInteractiveWorkflowProject;
import org.eclipse.vtp.desktop.model.interactive.core.InteractionType;
import org.eclipse.vtp.desktop.model.interactive.core.InteractionTypeManager;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.InteractionBinding;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.MissingInteractionBinding;
import org.eclipse.vtp.desktop.model.interactive.core.mediadefaults.IMediaDefaultSettings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GenericBindingManager
implements ConfigurationManager {
    public static final String TYPE_ID = "org.eclipse.vtp.configuration.generic";
    public static final String XML_VERSION = "1.0.0";
    private BrandManager brandManager = null;
    private IMediaDefaultSettings mediaDefaults = null;
    private Map<String, MissingInteractionBinding> missingInteractionBindings = new TreeMap<String, MissingInteractionBinding>();
    private Map<String, InteractionBinding> interactionBindings = new TreeMap<String, InteractionBinding>();
    private IDesign hostDesign = null;

    public GenericBindingManager(IDesign design) {
        this.hostDesign = design;
        this.brandManager = design.getDocument().getProject().getBrandManager();
        this.mediaDefaults = ((IInteractiveWorkflowProject)design.getDocument().getProject()).getMediaDefaultSettings();
    }

    public String getType() {
        return TYPE_ID;
    }

    public String getXMLVersion() {
        return XML_VERSION;
    }

    public InteractionBinding getInteractionBinding(String interactionType) {
        InteractionBinding interactionBinding = this.interactionBindings.get(interactionType);
        if (interactionBinding == null) {
            interactionBinding = new InteractionBinding(this, interactionType);
            this.interactionBindings.put(interactionType, interactionBinding);
        }
        return interactionBinding;
    }

    public void readConfiguration(Element configuration) throws ConfigurationException {
        NodeList interactionElementList = configuration.getElementsByTagName("interaction-binding");
        int i = 0;
        while (i < interactionElementList.getLength()) {
            Element interactionElement = (Element)interactionElementList.item(i);
            String interactionTypeId = interactionElement.getAttribute("type");
            InteractionType interactionType = InteractionTypeManager.getInstance().getType(interactionTypeId);
            if (interactionType != null) {
                InteractionBinding interactionBinding = new InteractionBinding(this, interactionTypeId);
                interactionBinding.readConfiguration(interactionElement);
                this.interactionBindings.put(interactionTypeId, interactionBinding);
            } else {
                MissingInteractionBinding missingInteractionBinding = new MissingInteractionBinding(interactionElement);
                this.missingInteractionBindings.put(interactionTypeId, missingInteractionBinding);
            }
            ++i;
        }
    }

    public void writeConfiguration(Element configuration) {
        TreeMap<String, Object> tempMap = new TreeMap<String, Object>();
        tempMap.putAll(this.interactionBindings);
        tempMap.putAll(this.missingInteractionBindings);
        for (Object obj : tempMap.values()) {
            if (obj instanceof InteractionBinding) {
                InteractionBinding interactionBinding = (InteractionBinding)obj;
                Element interactionElement = configuration.getOwnerDocument().createElement("interaction-binding");
                configuration.appendChild(interactionElement);
                interactionElement.setAttribute("type", interactionBinding.getInteractionType());
                interactionBinding.writeConfiguration(interactionElement);
                continue;
            }
            MissingInteractionBinding missingBinding = (MissingInteractionBinding)obj;
            missingBinding.writeConfiguration(configuration);
        }
    }

    public Object clone() {
        GenericBindingManager copy = new GenericBindingManager(this.hostDesign);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.getDOMImplementation().createDocument(null, "temporary-document", null);
            Element rootElement = document.getDocumentElement();
            rootElement.setAttribute("xml-version", XML_VERSION);
            this.writeConfiguration(rootElement);
            copy.readConfiguration(rootElement);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return copy;
    }

    public BrandManager getBrandManager() {
        return this.brandManager;
    }

    public IMediaDefaultSettings getMediaDefaults() {
        return this.mediaDefaults;
    }

    public void dumpContents(PrintStream out) {
        out.println("Generic Binding Manager\r\n");
        out.println("Interaction Bindings");
        for (InteractionBinding interactionBinding : this.interactionBindings.values()) {
            interactionBinding.dumpContents(out);
        }
    }

    public void renameNamedBinding(String interactionType, String oldName, String newName) {
        InteractionBinding ib = this.interactionBindings.get(interactionType);
        ib.renameNamedBinding(oldName, newName);
    }
}

