/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.interactive.core.configuration.generic;

import java.io.PrintStream;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.GenericBindingManager;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.LanguageBinding;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NamedBinding {
    private String name = null;
    private GenericBindingManager manager = null;
    private Map<String, LanguageBinding> languageBindings = new TreeMap<String, LanguageBinding>();

    public NamedBinding(GenericBindingManager manager, String name) {
        this.manager = manager;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void duplicateLanguageBinding(String sourceLanguage, String destinationLanguage, boolean force) throws IllegalStateException {
        if (this.languageBindings.get(destinationLanguage) != null && !force) {
            throw new IllegalStateException("That langauge already has configuration present");
        }
        LanguageBinding sourceBinding = this.languageBindings.get(sourceLanguage);
        if (sourceBinding == null) {
            return;
        }
        this.languageBindings.put(destinationLanguage, sourceBinding.replicate(destinationLanguage));
    }

    public LanguageBinding getLanguageBinding(String languageName) {
        LanguageBinding languageBinding = this.languageBindings.get(languageName);
        if (languageBinding == null) {
            languageBinding = new LanguageBinding(this.manager, languageName);
            this.languageBindings.put(languageName, languageBinding);
        }
        return languageBinding;
    }

    public void readConfiguration(Element namedBindingElement) {
        NodeList languageBindingElementList = namedBindingElement.getElementsByTagName("language-binding");
        int i = 0;
        while (i < languageBindingElementList.getLength()) {
            Element languageBindingElement = (Element)languageBindingElementList.item(i);
            String language = languageBindingElement.getAttribute("language");
            LanguageBinding languageBinding = new LanguageBinding(this.manager, language);
            languageBinding.readConfiguration(languageBindingElement);
            this.languageBindings.put(language, languageBinding);
            ++i;
        }
    }

    public void writeConfiguration(Element namedBindingElement) {
        for (LanguageBinding languageBinding : this.languageBindings.values()) {
            Element languageBindingElement = namedBindingElement.getOwnerDocument().createElement("language-binding");
            namedBindingElement.appendChild(languageBindingElement);
            languageBindingElement.setAttribute("language", languageBinding.getLanguage());
            languageBinding.writeConfiguration(languageBindingElement);
        }
    }

    public void dumpContents(PrintStream out) {
        out.println("[Named Binding] " + this.name);
        out.println("Language Bindings");
        for (LanguageBinding languageBinding : this.languageBindings.values()) {
            languageBinding.dumpContents(out);
        }
    }
}

