/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.interactive.core.configuration.generic;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.BindingItem;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.PromptBindingEntry;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.PromptBindingNode;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.PromptBindingSwitch;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PromptBindingItem
implements BindingItem {
    public static final String TYPE_ID = "org.eclipse.vtp.configuration.generic.items.prompt";
    private List<PromptBindingNode> entries = new ArrayList<PromptBindingNode>();

    @Override
    public String getType() {
        return TYPE_ID;
    }

    public void clearEntries() {
        this.entries.clear();
    }

    public List<PromptBindingNode> getEntries() {
        return this.entries;
    }

    public void addEntry(PromptBindingNode entry) {
        this.entries.add(entry);
    }

    @Override
    public void readConfiguration(Element configuration) {
        NodeList contentList = configuration.getChildNodes();
        int i = 0;
        while (i < contentList.getLength()) {
            if (contentList.item(i) instanceof Element) {
                Element element = (Element)contentList.item(i);
                PromptBindingNode child = null;
                child = "binding-branch".equals(element.getTagName()) ? new PromptBindingSwitch() : new PromptBindingEntry();
                child.readConfiguration(element);
                this.entries.add(child);
            }
            ++i;
        }
    }

    @Override
    public void writeConfiguration(Element configuration) {
        for (PromptBindingNode entry : this.entries) {
            entry.writeConfiguration(configuration);
        }
    }

    @Override
    public Object clone() {
        PromptBindingItem copy = new PromptBindingItem();
        for (PromptBindingNode entry : this.entries) {
            copy.addEntry((PromptBindingNode)entry.clone());
        }
        return copy;
    }
}

