/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.interactive.core.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.vtp.desktop.model.core.branding.BrandManager;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowProject;
import org.eclipse.vtp.desktop.model.interactive.core.IInteractiveWorkflowProject;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaProject;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaProviderManager;
import org.eclipse.vtp.desktop.model.interactive.core.InteractiveWorkflowCore;
import org.eclipse.vtp.desktop.model.interactive.core.internal.InteractionTypeSupport;
import org.eclipse.vtp.desktop.model.interactive.core.internal.LanguageSupport;
import org.eclipse.vtp.desktop.model.interactive.core.internal.mediadefaults.WorkspaceMediaDefaultSettings;
import org.eclipse.vtp.desktop.model.interactive.core.mediadefaults.IMediaDefaultSetting;
import org.eclipse.vtp.desktop.model.interactive.core.mediadefaults.IMediaDefaultSettings;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class InteractiveWorkflowProject
extends WorkflowProject
implements IInteractiveWorkflowProject,
IMediaProviderManager {
    private Map<String, InteractionTypeSupport> supportedInteractionTypes = new HashMap<String, InteractionTypeSupport>();
    private MediaDefaultSettings mediaDefaultSettings = new MediaDefaultSettings();

    public InteractiveWorkflowProject(IProject project) {
        super(project, false);
        this.loadBuildPath();
    }

    @Override
    public List<String> getSupportedInteractionTypes() {
        return new ArrayList<String>(this.supportedInteractionTypes.keySet());
    }

    @Override
    public List<String> getSupportedLanguages(String interactionType) {
        LinkedList<String> languages = new LinkedList<String>();
        InteractionTypeSupport interactionTypeSupport = this.supportedInteractionTypes.get(interactionType);
        if (interactionTypeSupport != null) {
            List<LanguageSupport> supportedLanguages = interactionTypeSupport.getSupportedLanguages();
            for (LanguageSupport language : supportedLanguages) {
                languages.add(language.getLanguage());
            }
        }
        return languages;
    }

    public List<InteractionTypeSupport> getInteractionTypeSupport() {
        ArrayList<InteractionTypeSupport> ret = new ArrayList<InteractionTypeSupport>();
        for (Map.Entry<String, InteractionTypeSupport> entry : this.supportedInteractionTypes.entrySet()) {
            ret.add((InteractionTypeSupport)entry.getValue().clone());
        }
        return ret;
    }

    public void setInteractionTypeSupport(List<InteractionTypeSupport> newSupport) {
        this.supportedInteractionTypes.clear();
        for (InteractionTypeSupport its : newSupport) {
            this.supportedInteractionTypes.put(its.getInteractionType(), its);
        }
        this.storeBuildPath();
    }

    @Override
    public IMediaDefaultSettings getMediaDefaultSettings() {
        return this.mediaDefaultSettings;
    }

    @Override
    public IMediaProviderManager getMediaProviderManager() {
        return this;
    }

    @Override
    public IInteractiveWorkflowProject getInteractiveWorkflowProject() {
        return this;
    }

    @Override
    public IMediaProject getMediaProject(String interactionType, IBrand brand, String language) {
        IMediaProject mediaProject;
        String mediaProjectId;
        LanguageSupport languageSupport;
        InteractionTypeSupport typeSupport = this.supportedInteractionTypes.get(interactionType);
        if (typeSupport != null && (languageSupport = typeSupport.getLanguageSupport(language)) != null && (mediaProjectId = languageSupport.getMediaProjectId(brand, true)) != null && (mediaProject = InteractiveWorkflowCore.getDefault().getInteractiveWorkflowModel().getMediaProject(mediaProjectId)) != null) {
            return mediaProject;
        }
        return null;
    }

    @Override
    public IMediaProvider getMediaProvider(String interactionType, IBrand brand, String language) {
        IMediaProject mediaProject = this.getMediaProject(interactionType, brand, language);
        if (mediaProject != null) {
            return mediaProject.getMediaProvider();
        }
        return null;
    }

    protected void loadBuildPathSection(Element sectionElement) {
        if (sectionElement.getNodeName().equals("interaction-type-support")) {
            NodeList itList = sectionElement.getElementsByTagName("interaction-type");
            int i = 0;
            while (i < itList.getLength()) {
                Element it = (Element)itList.item(i);
                String interactionType = it.getAttribute("id");
                String interactionTypeName = it.getAttribute("name");
                InteractionTypeSupport interactionTypeSupport = this.supportedInteractionTypes.get(interactionType);
                if (interactionTypeSupport == null) {
                    interactionTypeSupport = new InteractionTypeSupport(interactionType, interactionTypeName);
                    this.supportedInteractionTypes.put(interactionType, interactionTypeSupport);
                }
                NodeList lmList = it.getElementsByTagName("language-mapping");
                int l = 0;
                while (l < lmList.getLength()) {
                    Element lm = (Element)lmList.item(l);
                    String language = lm.getAttribute("language");
                    LanguageSupport languageSupport = interactionTypeSupport.getLanguageSupport(language);
                    if (languageSupport == null) {
                        languageSupport = interactionTypeSupport.addLanguageSupport(language);
                    }
                    NodeList bmList = lm.getElementsByTagName("brand-mapping");
                    int b = 0;
                    while (b < bmList.getLength()) {
                        Element bm = (Element)bmList.item(b);
                        String brandId = bm.getAttribute("brand-id");
                        String mediaProjectId = bm.getAttribute("media-project-id");
                        languageSupport.assignMediaProject(brandId, mediaProjectId);
                        ++b;
                    }
                    ++l;
                }
                ++i;
            }
        } else if (sectionElement.getNodeName().equals("media-defaults")) {
            NodeList nl = sectionElement.getElementsByTagName("media-default");
            int i = 0;
            while (i < nl.getLength()) {
                Element defaultElement = (Element)nl.item(i);
                String interactionType = defaultElement.getAttribute("interaction-type");
                String elementType = defaultElement.getAttribute("element-type");
                String settingName = defaultElement.getAttribute("name");
                String value = defaultElement.getAttribute("value");
                if (value != null && !value.equals("")) {
                    this.mediaDefaultSettings.addDefaultSetting(interactionType, elementType, settingName, value);
                }
                ++i;
            }
        } else {
            super.loadBuildPathSection(sectionElement);
        }
    }

    protected void writeBuildPathSections(Element rootElement) {
        super.writeBuildPathSections(rootElement);
        Document document = rootElement.getOwnerDocument();
        Element interactionTypeSupportElement = document.createElement("interaction-type-support");
        rootElement.appendChild(interactionTypeSupportElement);
        for (InteractionTypeSupport interactionTypeSupport : this.supportedInteractionTypes.values()) {
            Element interactionTypeElement = document.createElement("interaction-type");
            interactionTypeSupportElement.appendChild(interactionTypeElement);
            interactionTypeElement.setAttribute("id", interactionTypeSupport.getInteractionType());
            interactionTypeElement.setAttribute("name", interactionTypeSupport.getInteractionTypeName());
            List<LanguageSupport> supportedLanguages = interactionTypeSupport.getSupportedLanguages();
            for (LanguageSupport languageSupport : supportedLanguages) {
                Element languageSupportElement = document.createElement("language-mapping");
                interactionTypeElement.appendChild(languageSupportElement);
                languageSupportElement.setAttribute("language", languageSupport.getLanguage());
                for (IBrand brand : this.flattenBrands()) {
                    String mediaProjectId = languageSupport.getMediaProjectId(brand, false);
                    if (mediaProjectId == null) continue;
                    Element brandMappingElement = document.createElement("brand-mapping");
                    languageSupportElement.appendChild(brandMappingElement);
                    brandMappingElement.setAttribute("brand-id", brand.getId());
                    brandMappingElement.setAttribute("media-project-id", mediaProjectId);
                }
            }
        }
        Element mediaDefaultsElement = document.createElement("media-defaults");
        rootElement.appendChild(mediaDefaultsElement);
        for (MediaDefaultSetting mediaDefaultSetting : this.mediaDefaultSettings.settings.values()) {
            if (mediaDefaultSetting.isValueInherited() || mediaDefaultSetting.getValue() == null || mediaDefaultSetting.getValue().equals("")) continue;
            Element mediaDefaultElement = document.createElement("media-default");
            mediaDefaultsElement.appendChild(mediaDefaultElement);
            mediaDefaultElement.setAttribute("interaction-type", mediaDefaultSetting.getInteractionType());
            mediaDefaultElement.setAttribute("element-type", mediaDefaultSetting.getElementType());
            mediaDefaultElement.setAttribute("name", mediaDefaultSetting.getName());
            mediaDefaultElement.setAttribute("value", mediaDefaultSetting.getValue());
        }
    }

    private List<IBrand> flattenBrands() {
        LinkedList<IBrand> ret = new LinkedList<IBrand>();
        BrandManager brandManager = this.getBrandManager();
        IBrand defaultBrand = brandManager.getDefaultBrand();
        this.flattenBrand(ret, defaultBrand);
        return ret;
    }

    private void flattenBrand(List<IBrand> list, IBrand brand) {
        list.add(brand);
        for (IBrand child : brand.getChildBrands()) {
            this.flattenBrand(list, child);
        }
    }

    protected void initializeBuildPath() {
        super.initializeBuildPath();
    }

    public void storeMediaDefaultSettings() {
        this.storeBuildPath();
    }

    private class MediaDefaultSetting
    implements IMediaDefaultSetting {
        String interactionType = "";
        String elementType = "";
        String setting = "";
        String settingValue = "";
        boolean inherited = false;

        public MediaDefaultSetting(String interactionType, String elementType, String setting) {
            this.interactionType = interactionType;
            this.elementType = elementType;
            this.setting = setting;
            this.inherited = true;
            this.settingValue = WorkspaceMediaDefaultSettings.getInstance().getDefaultSetting(interactionType, elementType, setting).getValue();
        }

        @Override
        public String getElementType() {
            return this.elementType;
        }

        @Override
        public String getInteractionType() {
            return this.interactionType;
        }

        @Override
        public String getName() {
            return this.setting;
        }

        @Override
        public String getValue() {
            return this.settingValue;
        }

        @Override
        public boolean isValueInherited() {
            return this.inherited;
        }

        @Override
        public void setValue(String value) {
            if (this.inherited) {
                if (value != null && !value.equals("")) {
                    this.inherited = false;
                    this.settingValue = value;
                }
            } else if (value == null || value.equals("")) {
                this.inherited = true;
                this.settingValue = WorkspaceMediaDefaultSettings.getInstance().getDefaultSetting(this.interactionType, this.elementType, this.setting).getValue();
            } else {
                this.settingValue = value;
            }
        }
    }

    public class MediaDefaultSettings
    implements IMediaDefaultSettings {
        public Map<String, MediaDefaultSetting> settings = new HashMap<String, MediaDefaultSetting>();

        @Override
        public IMediaDefaultSetting getDefaultSetting(String interactionType, String elementType, String setting) {
            String key = String.valueOf(interactionType) + ":" + elementType + ":" + setting;
            MediaDefaultSetting defaultSetting = this.settings.get(key);
            if (defaultSetting == null) {
                defaultSetting = new MediaDefaultSetting(interactionType, elementType, setting);
                this.settings.put(key, defaultSetting);
            }
            return defaultSetting;
        }

        void addDefaultSetting(String interactionType, String elementType, String settingName, String value) {
            String key = String.valueOf(interactionType) + ":" + elementType + ":" + settingName;
            MediaDefaultSetting setting = this.settings.get(key);
            if (setting == null) {
                setting = new MediaDefaultSetting(interactionType, elementType, settingName);
                this.settings.put(key, setting);
            }
            setting.setValue(value);
        }

        @Override
        public boolean inheritanceSupported() {
            return true;
        }
    }
}

