/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.interactive.core.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaContainer;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaFile;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaFolder;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaObject;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaResource;
import org.eclipse.vtp.desktop.model.interactive.core.internal.MediaResource;
import org.eclipse.vtp.desktop.model.interactive.core.internal.MediaTypeManager;

public class MediaFolder
extends MediaResource
implements IMediaFolder {
    private static final String HASHPREFIX = "MEDIAFOLDER";
    IFolder folder;

    public MediaFolder(IMediaContainer container, IFolder folder) {
        super(container, (IResource)folder);
        this.folder = folder;
    }

    @Override
    public List<IMediaResource> listMediaResources() throws CoreException {
        ArrayList<IMediaResource> ret = new ArrayList<IMediaResource>();
        IResource[] res = this.folder.members();
        int i = 0;
        while (i < res.length) {
            if (!res[i].getName().startsWith(".")) {
                IFolder f;
                if (res[i] instanceof IFolder) {
                    f = (IFolder)res[i];
                    ret.add(new MediaFolder((IMediaContainer)this, f));
                } else {
                    f = (IFile)res[i];
                    IMediaFile mf = MediaTypeManager.getInstance().createMediaFile(this, (IFile)f);
                    if (mf != null) {
                        ret.add(mf);
                    }
                }
            }
            ++i;
        }
        return ret;
    }

    @Override
    public IMediaFolder getMediaFolder(String name) {
        IFolder f = this.folder.getFolder(name);
        return new MediaFolder((IMediaContainer)this, f);
    }

    @Override
    public IMediaFile getMediaFile(String name) {
        IFile f = this.folder.getFile(name);
        IMediaFile mf = MediaTypeManager.getInstance().createMediaFile(this, f);
        return mf;
    }

    @Override
    public IMediaFile create(String name) throws CoreException {
        return this.create(name, new ByteArrayInputStream(new byte[0]), null);
    }

    @Override
    public IMediaFile create(String name, InputStream source, IProgressMonitor monitor) throws CoreException {
        IFile file = this.folder.getFile(name);
        IMediaFile mf = MediaTypeManager.getInstance().createMediaFile(this, file);
        if (mf != null) {
            file.create(source, false, null);
        }
        return mf;
    }

    @Override
    public IMediaFolder makeDirectory(String name) throws CoreException {
        IFolder f = this.folder.getFolder(name);
        f.create(false, true, null);
        return new MediaFolder((IMediaContainer)this, f);
    }

    public Object[] getChildren(Object o) {
        try {
            return this.listMediaResources().toArray();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return new Object[0];
        }
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    @Override
    public List<IMediaObject> getChildren() {
        try {
            return new LinkedList<IMediaObject>(this.listMediaResources());
        }
        catch (CoreException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    @Override
    public IFolder getUnderlyingFolder() {
        return this.folder;
    }

    @Override
    public Object getAdapter(Class adapterClass) {
        if (adapterClass.isAssignableFrom(IFolder.class)) {
            return this.folder;
        }
        return super.getAdapter(adapterClass);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MediaFolder) {
            return this.folder.equals((Object)((MediaFolder)obj).getUnderlyingFolder());
        }
        return false;
    }

    public int hashCode() {
        return (HASHPREFIX + this.folder.toString()).hashCode();
    }
}

