/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.interactive.core.internal;

import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaFilesFolder;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaObject;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaObjectContainer;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaProject;
import org.eclipse.vtp.desktop.model.interactive.core.IPromptSet;
import org.eclipse.vtp.desktop.model.interactive.core.internal.MediaFilesFolder;
import org.eclipse.vtp.desktop.model.interactive.core.internal.MediaObject;
import org.eclipse.vtp.desktop.model.interactive.core.internal.PromptSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class MediaProject
extends MediaObject
implements IMediaProject {
    private static final String HASHPREFIX = "MEDIAPROJECT";
    protected IProject project = null;
    private String id = null;

    public MediaProject(IProject project) {
        this.project = project;
        try {
            IFile buildPath = project.getFile(".config");
            DocumentBuilderFactory buildFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = buildFactory.newDocumentBuilder();
            if (!buildPath.isSynchronized(2)) {
                buildPath.refreshLocal(2, null);
            }
            Document doc = builder.parse(buildPath.getContents());
            Element root = doc.getDocumentElement();
            this.loadConfig(root);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void loadConfig(Element rootElement) {
        this.id = rootElement.getAttribute("id");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IPromptSet getPromptSet() {
        return new PromptSet(this.project.getFile("Prompts.xml"), this);
    }

    @Override
    public IMediaFilesFolder getMediaFilesFolder() {
        IFolder f = this.project.getFolder("Media Files");
        if (!f.exists()) {
            throw new RuntimeException("Media Files is missing");
        }
        return new MediaFilesFolder(this, f);
    }

    @Override
    public List<IMediaObject> getChildren() {
        LinkedList<IMediaObject> children = new LinkedList<IMediaObject>();
        children.add(this.getPromptSet());
        children.add(this.getMediaFilesFolder());
        return children;
    }

    @Override
    protected String getObjectId() {
        return this.project.getFullPath().toPortableString();
    }

    @Override
    public IMediaProject getProject() {
        return this;
    }

    @Override
    public String getName() {
        return this.project.getName();
    }

    @Override
    public IMediaObjectContainer getParent() {
        return null;
    }

    @Override
    public IProject getUnderlyingProject() {
        return this.project;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IMediaProject) {
            return this.project.equals((Object)((IMediaProject)obj).getUnderlyingProject());
        }
        return false;
    }

    public int hashCode() {
        return (HASHPREFIX + this.project.toString()).hashCode();
    }
}

