/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.interactive.core.internal;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaContainer;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaFolder;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaObjectContainer;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaResource;
import org.eclipse.vtp.desktop.model.interactive.core.internal.MediaObject;

public abstract class MediaResource
extends MediaObject
implements IMediaResource {
    IResource resource;
    IMediaContainer container;

    public MediaResource(IMediaContainer container, IResource resource) {
        this.resource = resource;
        this.container = container;
    }

    @Override
    public boolean exists() {
        return this.resource.exists();
    }

    @Override
    public IMediaContainer getParentMediaContainer() {
        return this.container;
    }

    @Override
    public IMediaObjectContainer getParent() {
        return this.container;
    }

    @Override
    public String getName() {
        return this.resource.getName();
    }

    @Override
    protected String getObjectId() {
        return this.resource.getFullPath().toPortableString();
    }

    @Override
    public void delete() throws CoreException {
        this.resource.delete(false, null);
    }

    @Override
    public String getMediaPath() {
        String path = "";
        IMediaObjectContainer obj = this.getParent();
        if (obj instanceof IMediaFolder) {
            path = ((IMediaFolder)obj).getMediaPath();
        }
        path = String.valueOf(path) + "/" + this.getName();
        return path;
    }
}

