/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.interactive.core.internal.mediadefaults;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class DefaultSettingsRegistry {
    public static final String configurationManagerExtensionId = "org.eclipse.vtp.desktop.model.interactive.core.defaultSettings";
    private static final DefaultSettingsRegistry instance = new DefaultSettingsRegistry();
    List<DefaultSettingGroupRecord> managerRecords = new ArrayList<DefaultSettingGroupRecord>();

    public static DefaultSettingsRegistry getInstance() {
        return instance;
    }

    public DefaultSettingsRegistry() {
        IConfigurationElement[] managerExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(configurationManagerExtensionId);
        int i = 0;
        while (i < managerExtensions.length) {
            String elementType = managerExtensions[i].getAttribute("element-type");
            String interactionType = managerExtensions[i].getAttribute("interaction-type");
            DefaultSettingGroupRecord cmr = new DefaultSettingGroupRecord(elementType, interactionType);
            this.managerRecords.add(cmr);
            IConfigurationElement[] settings = managerExtensions[i].getChildren("default-setting");
            int s = 0;
            while (s < settings.length) {
                String[] stringArray = settings[s].getAttributeNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String an = stringArray[n2];
                    System.out.println(String.valueOf(settings[s].getName()) + " " + an + " " + settings[s].getAttribute(an));
                    ++n2;
                }
                cmr.defaultSettings.put(settings[s].getAttribute("name"), settings[s].getAttribute("default-value"));
                ++s;
            }
            ++i;
        }
    }

    public List<String> getDefaultSettingNames(String elementType, String interactionType) {
        System.err.println("Getting default settings names for: " + elementType + " " + interactionType);
        for (DefaultSettingGroupRecord dsgr : this.managerRecords) {
            System.err.println("Checking record: " + dsgr.elementType + " " + dsgr.interactionType);
            if (!dsgr.elementType.equals(elementType) || !dsgr.interactionType.equals(interactionType)) continue;
            return new ArrayList<String>(dsgr.defaultSettings.keySet());
        }
        return Collections.emptyList();
    }

    public List<DefaultSettingGroupRecord> getDefaultRecords() {
        return this.managerRecords;
    }

    public class DefaultSettingGroupRecord {
        public String elementType;
        public String interactionType;
        public Map<String, String> defaultSettings = new HashMap<String, String>();

        public DefaultSettingGroupRecord(String elementType, String interactionType) {
            this.elementType = elementType;
            this.interactionType = interactionType;
        }
    }
}

