/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.interactive.core.internal.mediadefaults;

import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.vtp.desktop.model.interactive.core.InteractiveWorkflowCore;
import org.eclipse.vtp.desktop.model.interactive.core.internal.mediadefaults.DefaultSettingsRegistry;
import org.eclipse.vtp.desktop.model.interactive.core.mediadefaults.IMediaDefaultSetting;
import org.eclipse.vtp.desktop.model.interactive.core.mediadefaults.IMediaDefaultSettings;

public class WorkspaceMediaDefaultSettings
implements IMediaDefaultSettings {
    private static final WorkspaceMediaDefaultSettings instance = new WorkspaceMediaDefaultSettings();

    public static WorkspaceMediaDefaultSettings getInstance() {
        return instance;
    }

    private WorkspaceMediaDefaultSettings() {
    }

    @Override
    public IMediaDefaultSetting getDefaultSetting(String interactionType, String elementType, String setting) {
        return new WorkspaceMediaDefaultSetting(interactionType, elementType, setting);
    }

    @Override
    public boolean inheritanceSupported() {
        return false;
    }

    public List<String> getDefaultSettingNames(String elementType, String interactionType) {
        return DefaultSettingsRegistry.getInstance().getDefaultSettingNames(elementType, interactionType);
    }

    private class WorkspaceMediaDefaultSetting
    implements IMediaDefaultSetting {
        String interactionType = "";
        String elementType = "";
        String setting = "";

        public WorkspaceMediaDefaultSetting(String interactionType, String elementType, String setting) {
            this.interactionType = interactionType;
            this.elementType = elementType;
            this.setting = setting;
        }

        @Override
        public String getElementType() {
            return this.elementType;
        }

        @Override
        public String getInteractionType() {
            return this.interactionType;
        }

        @Override
        public String getName() {
            return this.setting;
        }

        @Override
        public String getValue() {
            IPreferenceStore preferenceStore = InteractiveWorkflowCore.getDefault().getPreferenceStore();
            String settingValue = preferenceStore.getString(String.valueOf(this.interactionType) + ":" + this.elementType + ":" + this.setting);
            System.out.println("got preference value " + this.interactionType + ":" + this.elementType + ":" + this.setting + ", " + settingValue);
            return settingValue;
        }

        @Override
        public boolean isValueInherited() {
            return false;
        }

        @Override
        public void setValue(String value) {
            InteractiveWorkflowCore.getDefault().getPreferenceStore().setValue(String.valueOf(this.interactionType) + ":" + this.elementType + ":" + this.setting, value);
        }
    }
}

