/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.interactive.voice.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.media.core.FormatterRegistration;
import org.eclipse.vtp.desktop.media.core.FormatterRegistrationManager;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaContainer;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaFilesFolder;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaObject;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaResource;
import org.eclipse.vtp.desktop.model.interactive.core.content.ContentType;
import org.eclipse.vtp.desktop.model.interactive.voice.internal.VoiceModel;
import org.eclipse.vtp.desktop.model.interactive.voice.internal.VoiceProject;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.FormattableContent;
import org.eclipse.vtp.framework.interactions.core.media.IContentType;
import org.eclipse.vtp.framework.interactions.core.media.IFormatManager;
import org.eclipse.vtp.framework.interactions.core.media.IFormatter;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProvider;
import org.eclipse.vtp.framework.interactions.core.media.IResourceManager;
import org.eclipse.vtp.framework.interactions.core.media.ISharedContentProvider;

public class VoiceMediaProvider
implements IMediaProvider {
    IFormatManager formatManager = new VoiceFormatManager();
    IResourceManager resourceManager = new VoiceResourceManager();
    ISharedContentProvider sharedContentProvider = new VoiceSharedContentManager();
    VoiceProject project = null;
    VoiceModel model = null;
    IFormatter formatter = null;

    public VoiceMediaProvider(VoiceProject project) {
        this.project = project;
        this.model = new VoiceModel(project);
        try {
            this.model.load();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        try {
            FormatterRegistration fr = FormatterRegistrationManager.getInstance().getFormatter(project.getLanguagePackId());
            this.formatter = fr.getFormatter();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IFormatManager getFormatManager() {
        return this.formatManager;
    }

    public IFormatter getFormatter() {
        return this.formatter;
    }

    public IResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public ISharedContentProvider getSharedContentProvider() {
        return this.sharedContentProvider;
    }

    public List<IContentType> getSupportedContentTypes() {
        ArrayList<IContentType> types = new ArrayList<IContentType>();
        types.add((IContentType)new ContentType("org.eclipse.vtp.framework.interactions.voice.media.content.audio", "Audio File"));
        types.add((IContentType)new ContentType("org.eclipse.vtp.framework.interactions.core.media.content.letters", "Characters"));
        types.add((IContentType)new ContentType("org.eclipse.vtp.framework.interactions.core.media.content.date", "Date"));
        types.add((IContentType)new ContentType("org.eclipse.vtp.framework.interactions.core.media.content.digits", "Digits"));
        types.add((IContentType)new ContentType("org.eclipse.vtp.framework.interactions.core.media.content.money", "Money"));
        types.add((IContentType)new ContentType("org.eclipse.vtp.framework.interactions.core.media.content.number", "Number"));
        types.add((IContentType)new ContentType("org.eclipse.vtp.framework.interactions.core.media.content.ordinal", "Ordinal"));
        types.add((IContentType)new ContentType("org.eclipse.vtp.framework.interactions.core.media.content.referenced", "Reference"));
        types.add((IContentType)new ContentType("org.eclipse.vtp.framework.interactions.core.media.content.text", "Text"));
        return types;
    }

    public boolean hasSharedContent() {
        return true;
    }

    private class VoiceFormatManager
    implements IFormatManager {
        private VoiceFormatManager() {
        }

        public String getFormat(FormattableContent content, String formatName) {
            if (formatName.equals("Default")) {
                return "Default";
            }
            return VoiceMediaProvider.this.formatter.getDefaultFormatDefintion(content, formatName);
        }

        public List<String> getFormats(FormattableContent content) {
            ArrayList<String> ret = new ArrayList<String>();
            ret.add("Default");
            ret.addAll(VoiceMediaProvider.this.formatter.getDefaultFormats(content));
            return ret;
        }
    }

    private class VoiceResourceManager
    implements IResourceManager {
        private VoiceResourceManager() {
        }

        public boolean isDirectoryResource(String path) {
            return path == null || path.endsWith("/") && this.find(path) != null;
        }

        public boolean isFileResource(String path) {
            return path != null && !path.endsWith("/") && this.find(path) != null;
        }

        public String[] listResources(String directoryPath) {
            IMediaObject resource = this.find(directoryPath);
            if (resource instanceof IMediaContainer) {
                List resources = null;
                try {
                    resources = ((IMediaContainer)resource).listMediaResources();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return null;
                }
                String[] results = new String[resources.size()];
                int i = 0;
                while (i < results.length) {
                    IMediaResource item = (IMediaResource)resources.get(i);
                    results[i] = item.getName();
                    if (item instanceof IMediaContainer) {
                        int n = i;
                        results[n] = String.valueOf(results[n]) + "/";
                    }
                    ++i;
                }
                return results;
            }
            return null;
        }

        private IMediaObject find(String path) {
            IMediaFilesFolder folder;
            if (path == null || path.length() == 0) {
                path = "/";
            }
            IMediaFilesFolder result = folder = VoiceMediaProvider.this.project.getMediaFilesFolder();
            StringTokenizer st = new StringTokenizer(path, "/");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (st.hasMoreTokens()) {
                    if ((folder = folder.getMediaFolder(token)) != null) continue;
                    return null;
                }
                result = folder.getMediaFolder(token);
                if (result != null) continue;
                result = folder.getMediaFile(token);
            }
            return result;
        }
    }

    private class VoiceSharedContentManager
    implements ISharedContentProvider {
        private VoiceSharedContentManager() {
        }

        public Content getSharedContent(String contentName) {
            return VoiceMediaProvider.this.model.getSharedContent(contentName);
        }

        public List<String> listSharedContent() {
            return Arrays.asList(VoiceMediaProvider.this.model.getSharedContentNames());
        }
    }
}

