/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.interactive.voice.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaProject;
import org.eclipse.vtp.desktop.model.interactive.core.IPromptSet;
import org.eclipse.vtp.desktop.model.interactive.core.InteractionType;
import org.eclipse.vtp.desktop.model.interactive.core.InteractionTypeManager;
import org.eclipse.vtp.desktop.model.interactive.core.internal.MediaProject;
import org.eclipse.vtp.desktop.model.interactive.core.internal.PromptSet;
import org.eclipse.vtp.desktop.model.interactive.voice.IVoiceMediaProject;
import org.eclipse.vtp.desktop.model.interactive.voice.internal.VoiceMediaProvider;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProvider;
import org.w3c.dom.Element;

public class VoiceProject
extends MediaProject
implements IVoiceMediaProject {
    private VoiceMediaProvider mediaProvider;
    private PromptSet promptSet;
    private String languagePackId;

    public VoiceProject(IProject project) {
        super(project);
        this.promptSet = new PromptSet(project.getFile("Voice.xml"), (IMediaProject)this);
        this.mediaProvider = new VoiceMediaProvider(this);
    }

    protected void loadConfig(Element rootElement) {
        super.loadConfig(rootElement);
        this.languagePackId = rootElement.getAttribute("language-pack-id");
    }

    public String getLanguagePackId() {
        return this.languagePackId;
    }

    public IPromptSet getPromptSet() {
        return this.promptSet;
    }

    public IMediaProvider getMediaProvider() {
        return this.mediaProvider;
    }

    public InteractionType getInteractionType() {
        return InteractionTypeManager.getInstance().getType("org.eclipse.vtp.framework.interactions.voice.interaction");
    }
}

