/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.legacy.v3_xTo3_X.legacysupport;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.model.legacy.v3_xTo3_X.XMLConverter;
import org.osgi.framework.Bundle;

public class LegacySupportManager {
    public static final String modelConvertsExtensionId = "org.eclipse.vtp.desktop.model.legacy.modelConverters";
    public static final String elementConvertsExtensionId = "org.eclipse.vtp.desktop.model.legacy.legacyElementConverters";
    public static final String configurationManagerConvertersExtensionId = "org.eclipse.vtp.desktop.model.legacy.legacyConfigurationManagerConverters";
    private static final LegacySupportManager INSTANCE = new LegacySupportManager();
    private Map<String, ModelConverter> modelConverters = new HashMap<String, ModelConverter>();
    private Map<String, LegacyElementConverter> elementConverters;
    private Map<String, LegacyConfigurationManagerConverter> configurationManagerConverters;

    public static LegacySupportManager getInstance() {
        return INSTANCE;
    }

    public LegacySupportManager() {
        IConfigurationElement[] modelConverterExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(modelConvertsExtensionId);
        int i = 0;
        while (i < modelConverterExtensions.length) {
            block11: {
                ModelConverter mc = new ModelConverter();
                mc.modelVersion = modelConverterExtensions[i].getAttribute("xml-version");
                String className = modelConverterExtensions[i].getAttribute("class");
                Bundle contributor = Platform.getBundle((String)modelConverterExtensions[i].getContributor().getName());
                try {
                    mc.converterClass = contributor.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    break block11;
                }
                this.modelConverters.put(mc.modelVersion, mc);
            }
            ++i;
        }
        this.elementConverters = new HashMap<String, LegacyElementConverter>();
        IConfigurationElement[] elementConverterExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(elementConvertsExtensionId);
        int i2 = 0;
        while (i2 < elementConverterExtensions.length) {
            block12: {
                LegacyElementConverter lec = new LegacyElementConverter();
                lec.tagName = elementConverterExtensions[i2].getAttribute("xml-element");
                lec.namespace = elementConverterExtensions[i2].getAttribute("xml-namespace");
                if (lec.namespace == null) {
                    lec.namespace = "";
                }
                String className = elementConverterExtensions[i2].getAttribute("class");
                Bundle contributor = Platform.getBundle((String)elementConverterExtensions[i2].getContributor().getName());
                try {
                    lec.converterClass = contributor.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    break block12;
                }
                this.elementConverters.put(String.valueOf(lec.namespace) + lec.tagName, lec);
            }
            ++i2;
        }
        this.configurationManagerConverters = new HashMap<String, LegacyConfigurationManagerConverter>();
        IConfigurationElement[] configurationManagerConverterExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(configurationManagerConvertersExtensionId);
        int i3 = 0;
        while (i3 < configurationManagerConverterExtensions.length) {
            block13: {
                LegacyConfigurationManagerConverter lec = new LegacyConfigurationManagerConverter();
                lec.tagName = configurationManagerConverterExtensions[i3].getAttribute("xml-element");
                lec.namespace = configurationManagerConverterExtensions[i3].getAttribute("xml-namespace");
                if (lec.namespace == null) {
                    lec.namespace = "";
                }
                String className = configurationManagerConverterExtensions[i3].getAttribute("class");
                Bundle contributor = Platform.getBundle((String)configurationManagerConverterExtensions[i3].getContributor().getName());
                try {
                    lec.converterClass = contributor.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    break block13;
                }
                this.configurationManagerConverters.put(String.valueOf(lec.namespace) + lec.tagName, lec);
            }
            ++i3;
        }
    }

    public XMLConverter getModelConverter(String xmlVersion) {
        ModelConverter modelConverter = this.modelConverters.get(xmlVersion);
        if (modelConverter != null) {
            try {
                return modelConverter.converterClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public XMLConverter getLegacyElementConverter(String tagName, String namespace) {
        LegacyElementConverter legacyElementConverter;
        String key = "";
        if (namespace != null) {
            key = namespace;
        }
        if ((legacyElementConverter = this.elementConverters.get(key = String.valueOf(key) + tagName)) != null) {
            try {
                return legacyElementConverter.converterClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public XMLConverter getLegacyConfigurationManagerConverter(String tagName, String namespace) {
        LegacyConfigurationManagerConverter legacyElementConverter;
        String key = "";
        if (namespace != null) {
            key = namespace;
        }
        if ((legacyElementConverter = this.configurationManagerConverters.get(key = String.valueOf(key) + tagName)) != null) {
            try {
                return legacyElementConverter.converterClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private class LegacyConfigurationManagerConverter {
        String tagName;
        String namespace;
        Class<XMLConverter> converterClass;

        private LegacyConfigurationManagerConverter() {
        }
    }

    private class LegacyElementConverter {
        String tagName;
        String namespace;
        Class<XMLConverter> converterClass;

        private LegacyElementConverter() {
        }
    }

    private class ModelConverter {
        String modelVersion;
        Class<XMLConverter> converterClass;

        private ModelConverter() {
        }
    }
}

