/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.legacy.v3_xTo3_X.update;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vtp.desktop.model.legacy.v3_xTo3_X.update.LegacyBrandManager;

public class LegacyBrand {
    private String id;
    private String name;
    private LegacyBrand parentBrand;
    private List<LegacyBrand> childBrands;
    private LegacyBrandManager manager;

    public LegacyBrand(String id, String name) {
        this.id = id;
        this.name = name;
        this.childBrands = new ArrayList<LegacyBrand>();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        if (newName.equals(this.name)) {
            return;
        }
        this.name = newName;
    }

    public LegacyBrand getParent() {
        return this.parentBrand;
    }

    public void setParent(LegacyBrand brand) {
        if (brand == this.parentBrand) {
            return;
        }
        this.checkParent(brand);
        this.parentBrand = brand;
        this.parentBrand.addChild(this);
    }

    public List<LegacyBrand> getChildBrands() {
        return Collections.unmodifiableList(this.childBrands);
    }

    protected void addChild(LegacyBrand child) {
        this.childBrands.remove(child);
        this.childBrands.add(child);
        child.setManager(this.manager);
    }

    protected void removeChild(LegacyBrand child) {
        this.childBrands.remove(child);
    }

    private void checkParent(LegacyBrand newParent) {
        if (newParent == null) {
            throw new IllegalArgumentException("Parent cannot be null");
        }
        int i = 0;
        while (i < this.childBrands.size()) {
            LegacyBrand child = this.childBrands.get(i);
            if (child.equals(newParent)) {
                throw new IllegalArgumentException("Circular reference detected in brand structure.");
            }
            child.checkParent(newParent);
            ++i;
        }
    }

    void setManager(LegacyBrandManager manager) {
        this.manager = manager;
    }

    public void delete() {
        int i = 0;
        while (i < this.childBrands.size()) {
            LegacyBrand child = this.childBrands.get(i);
            child.delete();
            ++i;
        }
        this.parentBrand.removeChild(this);
    }
}

