/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.legacy.v3_xTo3_X.update;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.desktop.model.legacy.v3_xTo3_X.XMLConverter;
import org.eclipse.vtp.desktop.model.legacy.v3_xTo3_X.legacysupport.ConversionException;
import org.eclipse.vtp.desktop.model.legacy.v3_xTo3_X.update.LegacyBrand;
import org.eclipse.vtp.desktop.model.legacy.v3_xTo3_X.update.LegacyBrandManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OldMediaToGenericConverter
implements XMLConverter {
    private LegacyBrandManager brandManager = null;
    private List<LegacyBrand> brands = new ArrayList<LegacyBrand>();
    private Map<String, Element> interactionElements = new HashMap<String, Element>();
    private Map<String, Element> namedElements = new HashMap<String, Element>();
    private Map<String, Element> languageElements = new HashMap<String, Element>();

    public OldMediaToGenericConverter(LegacyBrandManager brandManager) {
        this.brandManager = brandManager;
        this.addBrand(brandManager.getDefaultBrand());
    }

    @Override
    public void convert(Element element) throws ConversionException {
        Element parentElement = (Element)element.getParentNode();
        Element newManagedConfigElement = parentElement.getOwnerDocument().createElement("managed-config");
        parentElement.appendChild(newManagedConfigElement);
        newManagedConfigElement.setAttribute("type", "org.eclipse.vtp.configuration.generic");
        newManagedConfigElement.setAttribute("xml-version", "1.0.0");
        NodeList promptBindingElementList = element.getElementsByTagNameNS("http://eclipse.org/vtp/xml/configuration/media", "prompt-binding");
        int i = 0;
        while (i < promptBindingElementList.getLength()) {
            Element promptBindingElement = (Element)promptBindingElementList.item(i);
            String bindingName = promptBindingElement.getAttribute("name");
            NodeList promptItemElementList = promptBindingElement.getElementsByTagName("item");
            int pi = 0;
            while (pi < promptItemElementList.getLength()) {
                LegacyBrand itemBrand = null;
                String itemLanguage = null;
                String interactionId = null;
                Element promptItemElement = (Element)promptItemElementList.item(pi);
                String key = promptItemElement.getAttribute("key");
                for (LegacyBrand brand : this.brands) {
                    if (!key.startsWith(brand.getName())) continue;
                    itemBrand = brand;
                    key = key.substring(brand.getName().length());
                    break;
                }
                List<String> interactionTypes = this.brandManager.getSupportedInteractionTypes();
                for (String interactionType : interactionTypes) {
                    if (!key.startsWith(interactionType)) continue;
                    interactionId = interactionType;
                    itemLanguage = key = key.substring(interactionType.length());
                    break;
                }
                if (itemBrand != null && itemLanguage != null && interactionId != null) {
                    Object newLanguageBindingElement;
                    Object newNamedBindingElement;
                    Element newInteractionBindingElement = this.interactionElements.get(interactionId);
                    if (newInteractionBindingElement == null) {
                        newInteractionBindingElement = parentElement.getOwnerDocument().createElement("interaction-binding");
                        newManagedConfigElement.appendChild(newInteractionBindingElement);
                        newInteractionBindingElement.setAttribute("type", interactionId);
                        this.interactionElements.put(interactionId, newInteractionBindingElement);
                    }
                    if ((newNamedBindingElement = this.namedElements.get(String.valueOf(interactionId) + bindingName)) == null) {
                        newNamedBindingElement = parentElement.getOwnerDocument().createElement("named-binding");
                        newInteractionBindingElement.appendChild((Node)newNamedBindingElement);
                        newNamedBindingElement.setAttribute("name", bindingName);
                        this.namedElements.put(String.valueOf(interactionId) + bindingName, (Element)newNamedBindingElement);
                    }
                    if ((newLanguageBindingElement = this.languageElements.get(String.valueOf(interactionId) + bindingName + itemLanguage)) == null) {
                        newLanguageBindingElement = parentElement.getOwnerDocument().createElement("language-binding");
                        newNamedBindingElement.appendChild((Node)newLanguageBindingElement);
                        newLanguageBindingElement.setAttribute("language", itemLanguage);
                        this.languageElements.put(String.valueOf(interactionId) + bindingName + itemLanguage, (Element)newLanguageBindingElement);
                    }
                    Element newBrandBindingElement = parentElement.getOwnerDocument().createElement("brand-binding");
                    newLanguageBindingElement.appendChild(newBrandBindingElement);
                    newBrandBindingElement.setAttribute("id", itemBrand.getId());
                    Element bindingItemElement = parentElement.getOwnerDocument().createElement("binding-item");
                    newBrandBindingElement.appendChild(bindingItemElement);
                    bindingItemElement.setAttribute("type", "org.eclipse.vtp.configuration.generic.items.prompt");
                    NodeList promptBindingEntryList = promptItemElement.getChildNodes();
                    int en = 0;
                    while (en < promptBindingEntryList.getLength()) {
                        if (promptBindingEntryList.item(en).getNodeType() == 1) {
                            Element promptBindingEntryElement = (Element)promptBindingEntryList.item(en);
                            bindingItemElement.appendChild(promptBindingEntryElement.cloneNode(true));
                        }
                        ++en;
                    }
                }
                ++pi;
            }
            ++i;
        }
        NodeList grammarBindingElementList = element.getElementsByTagNameNS("http://eclipse.org/vtp/xml/configuration/media", "grammar-binding");
        int i2 = 0;
        while (i2 < grammarBindingElementList.getLength()) {
            Element grammarBindingElement = (Element)grammarBindingElementList.item(i2);
            String bindingName = grammarBindingElement.getAttribute("name");
            NodeList grammarItemElementList = grammarBindingElement.getElementsByTagName("item");
            int pi = 0;
            while (pi < grammarItemElementList.getLength()) {
                LegacyBrand itemBrand = null;
                String itemLanguage = null;
                String interactionId = null;
                Element grammarItemElement = (Element)grammarItemElementList.item(pi);
                String key = grammarItemElement.getAttribute("key");
                for (LegacyBrand brand : this.brands) {
                    if (!key.startsWith(brand.getName())) continue;
                    itemBrand = brand;
                    key = key.substring(brand.getName().length());
                    break;
                }
                List<String> interactionTypes = this.brandManager.getSupportedInteractionTypes();
                for (String interactionType : interactionTypes) {
                    if (!key.startsWith(interactionType)) continue;
                    interactionId = interactionType;
                    itemLanguage = key = key.substring(interactionType.length());
                    break;
                }
                if (itemBrand != null && itemLanguage != null && interactionId != null) {
                    Object newLanguageBindingElement;
                    Object newNamedBindingElement;
                    Element newInteractionBindingElement = this.interactionElements.get(interactionId);
                    if (newInteractionBindingElement == null) {
                        newInteractionBindingElement = parentElement.getOwnerDocument().createElement("interaction-binding");
                        newManagedConfigElement.appendChild(newInteractionBindingElement);
                        newInteractionBindingElement.setAttribute("type", interactionId);
                        this.interactionElements.put(interactionId, newInteractionBindingElement);
                    }
                    if ((newNamedBindingElement = this.namedElements.get(String.valueOf(interactionId) + bindingName)) == null) {
                        newNamedBindingElement = parentElement.getOwnerDocument().createElement("named-binding");
                        newInteractionBindingElement.appendChild((Node)newNamedBindingElement);
                        newNamedBindingElement.setAttribute("name", bindingName);
                        this.namedElements.put(String.valueOf(interactionId) + bindingName, (Element)newNamedBindingElement);
                    }
                    if ((newLanguageBindingElement = this.languageElements.get(String.valueOf(interactionId) + bindingName + itemLanguage)) == null) {
                        newLanguageBindingElement = parentElement.getOwnerDocument().createElement("language-binding");
                        newNamedBindingElement.appendChild((Node)newLanguageBindingElement);
                        newLanguageBindingElement.setAttribute("language", itemLanguage);
                        this.languageElements.put(String.valueOf(interactionId) + bindingName + itemLanguage, (Element)newLanguageBindingElement);
                    }
                    Element newBrandBindingElement = parentElement.getOwnerDocument().createElement("brand-binding");
                    newLanguageBindingElement.appendChild(newBrandBindingElement);
                    newBrandBindingElement.setAttribute("id", itemBrand.getId());
                    Element bindingItemElement = parentElement.getOwnerDocument().createElement("binding-item");
                    newBrandBindingElement.appendChild(bindingItemElement);
                    bindingItemElement.setAttribute("type", "org.eclipse.vtp.configuration.generic.items.grammar");
                    NodeList grammarBindingEntryList = grammarItemElement.getChildNodes();
                    int en = 0;
                    while (en < grammarBindingEntryList.getLength()) {
                        if (grammarBindingEntryList.item(en).getNodeType() == 1) {
                            Element grammarBindingEntryElement = (Element)grammarBindingEntryList.item(en);
                            bindingItemElement.appendChild(grammarBindingEntryElement.cloneNode(true));
                        }
                        ++en;
                    }
                }
                ++pi;
            }
            ++i2;
        }
        NodeList propertyBindingElementList = element.getElementsByTagNameNS("http://eclipse.org/vtp/xml/configuration/media", "property-binding");
        int i3 = 0;
        while (i3 < propertyBindingElementList.getLength()) {
            Element propertyBindingElement = (Element)propertyBindingElementList.item(i3);
            String bindingName = propertyBindingElement.getAttribute("name");
            NodeList propertyItemElementList = propertyBindingElement.getElementsByTagName("item");
            int pi = 0;
            while (pi < propertyItemElementList.getLength()) {
                LegacyBrand itemBrand = null;
                String itemLanguage = null;
                String interactionId = null;
                Element propertyItemElement = (Element)propertyItemElementList.item(pi);
                String key = propertyItemElement.getAttribute("key");
                for (LegacyBrand brand : this.brands) {
                    if (!key.startsWith(brand.getName())) continue;
                    itemBrand = brand;
                    key = key.substring(brand.getName().length());
                    break;
                }
                List<String> interactionTypes = this.brandManager.getSupportedInteractionTypes();
                for (String interactionType : interactionTypes) {
                    if (!key.startsWith(interactionType)) continue;
                    interactionId = interactionType;
                    itemLanguage = key = key.substring(interactionType.length());
                    break;
                }
                if (itemBrand != null && itemLanguage != null && interactionId != null) {
                    Element newLanguageBindingElement;
                    Element newNamedBindingElement;
                    Element newInteractionBindingElement = this.interactionElements.get(interactionId);
                    if (newInteractionBindingElement == null) {
                        newInteractionBindingElement = parentElement.getOwnerDocument().createElement("interaction-binding");
                        newManagedConfigElement.appendChild(newInteractionBindingElement);
                        newInteractionBindingElement.setAttribute("type", interactionId);
                        this.interactionElements.put(interactionId, newInteractionBindingElement);
                    }
                    if ((newNamedBindingElement = this.namedElements.get(String.valueOf(interactionId) + bindingName)) == null) {
                        newNamedBindingElement = parentElement.getOwnerDocument().createElement("named-binding");
                        newInteractionBindingElement.appendChild(newNamedBindingElement);
                        newNamedBindingElement.setAttribute("name", bindingName);
                        this.namedElements.put(String.valueOf(interactionId) + bindingName, newNamedBindingElement);
                    }
                    if ((newLanguageBindingElement = this.languageElements.get(String.valueOf(interactionId) + bindingName + itemLanguage)) == null) {
                        newLanguageBindingElement = parentElement.getOwnerDocument().createElement("language-binding");
                        newNamedBindingElement.appendChild(newLanguageBindingElement);
                        newLanguageBindingElement.setAttribute("language", itemLanguage);
                        this.languageElements.put(String.valueOf(interactionId) + bindingName + itemLanguage, newLanguageBindingElement);
                    }
                    Element newBrandBindingElement = parentElement.getOwnerDocument().createElement("brand-binding");
                    newLanguageBindingElement.appendChild(newBrandBindingElement);
                    newBrandBindingElement.setAttribute("id", itemBrand.getId());
                    Element bindingItemElement = parentElement.getOwnerDocument().createElement("binding-item");
                    newBrandBindingElement.appendChild(bindingItemElement);
                    bindingItemElement.setAttribute("type", "org.eclipse.vtp.configuration.generic.items.property");
                    Element propertyEntryItemElement = parentElement.getOwnerDocument().createElement("property-value");
                    bindingItemElement.appendChild(propertyEntryItemElement);
                    propertyEntryItemElement.setAttribute("value-type", "static");
                    propertyEntryItemElement.setTextContent(propertyItemElement.getTextContent());
                }
                ++pi;
            }
            ++i3;
        }
        parentElement.removeChild(element);
    }

    private void addBrand(LegacyBrand brand) {
        this.brands.add(brand);
        List<LegacyBrand> children = brand.getChildBrands();
        for (LegacyBrand child : children) {
            this.addBrand(child);
        }
    }
}

