/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.legacy.v3_xTo4_0.dialogs;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class ConversionSelectionDialog
extends Dialog {
    Button allButton = null;
    Button selectedButton = null;
    CheckboxTableViewer viewer = null;
    List<ProjectRecord> convertableProjects = new LinkedList<ProjectRecord>();

    public ConversionSelectionDialog(Shell parentShell) {
        super(parentShell);
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                ProjectRecord pr;
                if (project.hasNature("org.eclipse.vtp.desktop.projects.core.VoiceApplicationNature")) {
                    pr = new ProjectRecord();
                    pr.project = project;
                    pr.type = "Application";
                    this.convertableProjects.add(pr);
                } else if (project.hasNature("org.eclipse.vtp.desktop.projects.core.VoiceApplicationFragmentNature")) {
                    pr = new ProjectRecord();
                    pr.project = project;
                    pr.type = "Fragment";
                    this.convertableProjects.add(pr);
                } else if (project.hasNature("org.eclipse.vtp.desktop.projects.voice.VoicePersonaNature")) {
                    pr = new ProjectRecord();
                    pr.project = project;
                    pr.type = "Voice";
                    this.convertableProjects.add(pr);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        comp.setLayout((Layout)new GridLayout(2, false));
        Label buttonLabel = new Label(comp, 0);
        buttonLabel.setText("Which 3.x projects should be converted?");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        buttonLabel.setLayoutData((Object)gd);
        this.allButton = new Button(comp, 16);
        this.allButton.setText("All Projects");
        this.allButton.setLayoutData((Object)new GridData());
        this.selectedButton = new Button(comp, 16);
        this.selectedButton.setText("Only Selected Projects");
        this.selectedButton.setLayoutData((Object)new GridData());
        this.allButton.setSelection(true);
        Composite tableComp = new Composite(comp, 0);
        TableColumnLayout tcLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)tcLayout);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.heightHint = 150;
        tableComp.setLayoutData((Object)gd);
        Table projectTable = new Table(tableComp, 68132);
        projectTable.setHeaderVisible(true);
        TableColumn nameColumn = new TableColumn(projectTable, 0);
        nameColumn.setText("Project Name");
        tcLayout.setColumnData((Widget)nameColumn, (ColumnLayoutData)new ColumnWeightData(60, 100));
        TableColumn typeColumn = new TableColumn(projectTable, 0);
        typeColumn.setText("Type");
        tcLayout.setColumnData((Widget)typeColumn, (ColumnLayoutData)new ColumnWeightData(40, 50));
        this.viewer = new CheckboxTableViewer(projectTable);
        ProjectContentProvider provider = new ProjectContentProvider();
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)provider);
        this.viewer.setCheckStateProvider((ICheckStateProvider)provider);
        this.viewer.setInput((Object)this);
        this.viewer.getControl().setEnabled(false);
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                for (ProjectRecord pr : ConversionSelectionDialog.this.convertableProjects) {
                    if (pr != event.getElement()) continue;
                    pr.selected = event.getChecked();
                    break;
                }
            }
        });
        this.selectedButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ConversionSelectionDialog.this.viewer.getTable().setEnabled(ConversionSelectionDialog.this.selectedButton.getSelection());
            }
        });
        return comp;
    }

    protected void okPressed() {
        super.okPressed();
    }

    public List<IProject> getProjectsToConvert() {
        ArrayList<IProject> ret = new ArrayList<IProject>();
        for (ProjectRecord pr : this.convertableProjects) {
            if (!pr.selected) continue;
            ret.add(pr.project);
        }
        return ret;
    }

    public class ProjectContentProvider
    extends BaseLabelProvider
    implements IStructuredContentProvider,
    ITableLabelProvider,
    ICheckStateProvider {
        public Object[] getElements(Object inputElement) {
            return ConversionSelectionDialog.this.convertableProjects.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ProjectRecord pr = (ProjectRecord)element;
            if (columnIndex == 0) {
                return pr.project.getName();
            }
            return pr.type;
        }

        public boolean isChecked(Object element) {
            return ((ProjectRecord)element).selected;
        }

        public boolean isGrayed(Object element) {
            return false;
        }
    }

    public class ProjectRecord {
        static final String APPLICATION = "Application";
        static final String FRAGMENT = "Fragment";
        static final String VOICE = "Voice";
        IProject project = null;
        String type = "Application";
        boolean selected = true;
    }
}

