/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.view;

import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.OpenFileAction;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.vtp.desktop.projects.core.view.AbstractWorkflowNavigatorActionGroup;

public class WorkflowNavigatorOpenEditorActionGroup
extends AbstractWorkflowNavigatorActionGroup {
    private OpenFileAction fOpenFileAction;

    public WorkflowNavigatorOpenEditorActionGroup(IViewPart viewPart) {
        super(viewPart);
    }

    @Override
    protected void makeActions() {
        this.fOpenFileAction = new OpenFileAction(this.getViewPart().getSite().getPage());
    }

    @Override
    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection elements = (IStructuredSelection)this.getContext().getSelection();
        LinkedList selectedList = new LinkedList();
        for (Object obj : elements.toList()) {
            IResource adapted;
            if (obj instanceof IResource) {
                selectedList.add(obj);
                continue;
            }
            if (obj instanceof IAdaptable && (adapted = (IResource)((IAdaptable)obj).getAdapter(IResource.class)) != null) {
                selectedList.add(adapted);
                continue;
            }
            selectedList.add(obj);
        }
        elements = new StructuredSelection(selectedList.toArray());
        this.fOpenFileAction.selectionChanged(elements);
        if (this.fOpenFileAction.isEnabled()) {
            menu.appendToGroup("group.open", (IAction)this.fOpenFileAction);
            this.fillOpenWithMenu(menu, elements);
        }
    }

    private void fillOpenWithMenu(IMenuManager menu, IStructuredSelection selection) {
        if (selection.size() != 1) {
            return;
        }
        Object element = selection.getFirstElement();
        if (!(element instanceof IFile)) {
            return;
        }
        MenuManager submenu = new MenuManager("Open Wit&h", "group.openWith");
        submenu.add((IContributionItem)new OpenWithMenu(this.getViewPart().getSite().getPage(), (IAdaptable)((IFile)element)));
        menu.insertAfter("group.openWith", (IContributionItem)submenu);
    }

    @Override
    public void fillActionBars(IActionBars actionBars) {
    }

    @Override
    public void updateActionBars() {
        IStructuredSelection celements = (IStructuredSelection)this.getContext().getSelection();
        this.fOpenFileAction.selectionChanged(celements);
    }

    IAction getOpenAction() {
        return this.fOpenFileAction;
    }
}

