/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.core.view;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelDecorator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.vtp.desktop.core.Activator;
import org.eclipse.vtp.desktop.model.core.IDependencySet;
import org.eclipse.vtp.desktop.model.core.IDesignDocument;
import org.eclipse.vtp.desktop.model.core.IWorkflowResource;
import org.eclipse.vtp.desktop.model.core.IWorkflowResourceContainer;

public class WorkflowProjectLabelProvider
implements ILabelProvider {
    ILabelProvider parentlabelProvider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();

    public Image getImage(Object element) {
        Image ret = null;
        if (element instanceof IDependencySet) {
            ret = Activator.getDefault().getImageRegistry().get("ICON_LIBRARY");
        }
        if (element instanceof IDesignDocument) {
            ret = this.getInheritedImage(element);
        }
        if (element instanceof IWorkflowResourceContainer) {
            ret = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (ret != null) {
            ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
            if (decorator != null) {
                Object obj = element;
                IResource resource = (IResource)((IAdaptable)element).getAdapter(IResource.class);
                if (resource != null) {
                    obj = resource;
                }
                if (decorator instanceof LabelDecorator) {
                    LabelDecorator ld2 = (LabelDecorator)decorator;
                    Image decorated = ld2.decorateImage(ret, obj, DecorationContext.DEFAULT_CONTEXT);
                    if (decorated != null) {
                        return decorated;
                    }
                } else {
                    Image decorated = decorator.decorateImage(ret, obj);
                    if (decorated != null) {
                        return decorated;
                    }
                }
            }
            return ret;
        }
        return this.getInheritedImage(element);
    }

    private Image getInheritedImage(Object element) {
        IResource resource;
        Image ret = null;
        if (element instanceof IAdaptable && (resource = (IResource)((IAdaptable)element).getAdapter(IResource.class)) != null) {
            ret = this.parentlabelProvider.getImage((Object)resource);
        }
        return ret;
    }

    public String getText(Object element) {
        if (element instanceof IProject) {
            return ((IProject)element).getName();
        }
        if (element instanceof IWorkflowResource) {
            return ((IWorkflowResource)element).getName();
        }
        return this.parentlabelProvider.getText(element);
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

