/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.interactive.core.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.vtp.desktop.model.core.IDesignDocument;
import org.eclipse.vtp.desktop.model.core.IDesignFolder;
import org.eclipse.vtp.desktop.model.core.IDesignItemContainer;
import org.eclipse.vtp.desktop.model.core.IDesignRootFolder;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.model.core.design.IDesign;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.interactive.core.IInteractiveWorkflowProject;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.GenericBindingManager;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.InteractionBinding;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.NamedBinding;

public class ReplicateLanguageDialog
extends Dialog {
    List<String> languages = new ArrayList<String>();
    IInteractiveWorkflowProject project;
    Combo sourceCombo = null;
    Combo destinationCombo = null;
    Button okButton = null;

    public ReplicateLanguageDialog(Shell parentShell) {
        super(parentShell);
    }

    public ReplicateLanguageDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Replicate Language Configuration");
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(3, false));
        Label sourceLabel = new Label(comp, 0);
        sourceLabel.setText("Source");
        sourceLabel.setLayoutData((Object)new GridData());
        Label iconLabel = new Label(comp, 0);
        iconLabel.setText("->");
        GridData gd = new GridData();
        gd.verticalSpan = 2;
        gd.verticalAlignment = 0x1000000;
        iconLabel.setLayoutData((Object)gd);
        Label destLabel = new Label(comp, 0);
        destLabel.setText("Destination");
        destLabel.setLayoutData((Object)new GridData());
        this.sourceCombo = new Combo(comp, 12);
        gd = new GridData(768);
        this.sourceCombo.setLayoutData((Object)gd);
        for (String lang : this.languages) {
            this.sourceCombo.add(lang);
        }
        this.sourceCombo.select(0);
        this.destinationCombo = new Combo(comp, 12);
        this.destinationCombo.setLayoutData((Object)new GridData(768));
        this.destinationCombo.add("Select Destination");
        int i = 1;
        while (i < this.languages.size()) {
            this.destinationCombo.add(this.languages.get(i));
            ++i;
        }
        this.destinationCombo.select(0);
        this.sourceCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ReplicateLanguageDialog.this.sourceCombo.getSelectionIndex() == -1) {
                    ReplicateLanguageDialog.this.sourceCombo.select(0);
                }
                ReplicateLanguageDialog.this.destinationCombo.removeAll();
                ReplicateLanguageDialog.this.destinationCombo.add("Select Destination");
                int i = 0;
                while (i < ReplicateLanguageDialog.this.sourceCombo.getSelectionIndex()) {
                    ReplicateLanguageDialog.this.destinationCombo.add(ReplicateLanguageDialog.this.languages.get(i));
                    ++i;
                }
                i = ReplicateLanguageDialog.this.sourceCombo.getSelectionIndex() + 1;
                while (i < ReplicateLanguageDialog.this.languages.size()) {
                    ReplicateLanguageDialog.this.destinationCombo.add(ReplicateLanguageDialog.this.languages.get(i));
                    ++i;
                }
                ReplicateLanguageDialog.this.destinationCombo.select(0);
                ReplicateLanguageDialog.this.okButton.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.destinationCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ReplicateLanguageDialog.this.okButton.setEnabled(ReplicateLanguageDialog.this.destinationCombo.getSelectionIndex() > 0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return comp;
    }

    protected Control createButtonBar(Composite parent) {
        Control ret = super.createButtonBar(parent);
        this.okButton = this.getButton(0);
        this.okButton.setEnabled(false);
        return ret;
    }

    protected void okPressed() {
        final String sourceLanguage = this.sourceCombo.getItem(this.sourceCombo.getSelectionIndex());
        final String destinationLanguage = this.destinationCombo.getItem(this.destinationCombo.getSelectionIndex());
        super.okPressed();
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getShell());
        try {
            pmd.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IDesignRootFolder root = ReplicateLanguageDialog.this.project.getDesignRootFolder();
                    int work = this.countContainer((IDesignItemContainer)root);
                    monitor.beginTask("Replicating language configuration", work);
                    this.processContainer((IDesignItemContainer)root, monitor);
                    monitor.done();
                    System.out.println("Done");
                }

                private void processContainer(IDesignItemContainer container, IProgressMonitor monitor) {
                    List folders = container.getDesignFolders();
                    for (IDesignFolder folder : folders) {
                        this.processContainer((IDesignItemContainer)folder, monitor);
                    }
                    List docs = container.getDesignDocuments();
                    for (IDesignDocument doc : docs) {
                        monitor.setTaskName("Processing " + doc.getUnderlyingFile().getProjectRelativePath().toString());
                        doc.becomeWorkingCopy();
                        this.processDesign(doc.getMainDesign(), monitor);
                        for (IDesign dialog : doc.getDialogDesigns()) {
                            this.processDesign(dialog, monitor);
                        }
                        try {
                            doc.commitWorkingCopy();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }

                private void processDesign(IDesign design, IProgressMonitor monitor) {
                    monitor.subTask(design.getName());
                    List elements = design.getDesignElements();
                    for (IDesignElement element : elements) {
                        GenericBindingManager manager = (GenericBindingManager)element.getConfigurationManager("org.eclipse.vtp.configuration.generic");
                        InteractionBinding ib = manager.getInteractionBinding("org.eclipse.vtp.framework.interactions.voice.interaction");
                        List nbs = ib.getNamedBindings();
                        for (NamedBinding nb : nbs) {
                            nb.duplicateLanguageBinding(sourceLanguage, destinationLanguage, true);
                        }
                        element.commitConfigurationChanges((ConfigurationManager)manager);
                    }
                    monitor.worked(1);
                }

                private int countContainer(IDesignItemContainer container) {
                    int ret = 0;
                    List folders = container.getDesignFolders();
                    for (IDesignFolder folder : folders) {
                        ret += this.countContainer((IDesignItemContainer)folder);
                    }
                    List docs = container.getDesignDocuments();
                    return ret += docs.size();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setLanguage(List<String> languages) {
        this.languages = languages;
    }

    public void setProject(IInteractiveWorkflowProject project) {
        this.project = project;
    }
}

