/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.interactive.core.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.vtp.desktop.model.core.WorkflowCore;
import org.eclipse.vtp.desktop.model.core.branding.BrandManager;
import org.eclipse.vtp.desktop.model.interactive.core.internal.InteractiveWorkflowProject;
import org.eclipse.vtp.desktop.projects.core.util.BrandConfigurationScreen;
import org.eclipse.vtp.desktop.projects.core.util.ConfigurationBrandManager;
import org.eclipse.vtp.desktop.projects.interactive.core.util.InteractionSupportManager;
import org.eclipse.vtp.desktop.projects.interactive.core.util.InteractionTypeConfigurationScreen;
import org.eclipse.vtp.desktop.projects.interactive.core.util.LanguageConfigurationScreen;

public class ApplicationProjectConfigurationPropertyPage
extends PropertyPage {
    private BrandConfigurationScreen brandScreen = new BrandConfigurationScreen();
    private InteractionTypeConfigurationScreen interactionScreen = new InteractionTypeConfigurationScreen();
    private LanguageConfigurationScreen languageScreen = new LanguageConfigurationScreen();
    private InteractiveWorkflowProject applicationProject = null;
    private ConfigurationBrandManager brandManager = null;
    private InteractionSupportManager supportManager = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setElement(IAdaptable element) {
        super.setElement(element);
        try {
            if (element instanceof InteractiveWorkflowProject) {
                this.applicationProject = (InteractiveWorkflowProject)element;
            } else {
                if (!(element instanceof IProject)) throw new RuntimeException("Unsupported element type");
                IProject project = (IProject)element;
                if (!WorkflowCore.getDefault().getWorkflowModel().isWorkflowProject(project)) throw new RuntimeException("Unsupported element type");
                this.applicationProject = (InteractiveWorkflowProject)WorkflowCore.getDefault().getWorkflowModel().convertToWorkflowProject(project);
            }
            this.brandManager = new ConfigurationBrandManager(this.applicationProject.getBrandManager());
            this.supportManager = new InteractionSupportManager();
            this.supportManager.init(this.applicationProject.getInteractionTypeSupport());
            this.brandScreen.init((BrandManager)this.brandManager);
            this.interactionScreen.setSupport(this.supportManager);
            this.languageScreen.init((BrandManager)this.brandManager, this.supportManager);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        TabFolder tabFolder = new TabFolder(comp, 0);
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem brandItem = new TabItem(tabFolder, 0);
        brandItem.setText("Brands");
        Composite brandComp = new Composite((Composite)tabFolder, 0);
        brandComp.setLayout((Layout)new FillLayout());
        this.brandScreen.createContents(brandComp);
        brandItem.setControl((Control)brandComp);
        TabItem interactionItem = new TabItem(tabFolder, 0);
        interactionItem.setText("Interaction Types");
        Composite interactionComp = new Composite((Composite)tabFolder, 0);
        interactionComp.setLayout((Layout)new FillLayout());
        this.interactionScreen.createContents(interactionComp);
        interactionItem.setControl((Control)interactionComp);
        TabItem languageItem = new TabItem(tabFolder, 0);
        languageItem.setText("Languages");
        Composite languageComp = new Composite((Composite)tabFolder, 0);
        languageComp.setLayout((Layout)new FillLayout());
        this.languageScreen.createContents(languageComp);
        languageItem.setControl((Control)languageComp);
        return comp;
    }

    protected void performDefaults() {
        this.brandManager = new ConfigurationBrandManager(this.applicationProject.getBrandManager());
        this.supportManager = new InteractionSupportManager();
        this.supportManager.init(this.applicationProject.getInteractionTypeSupport());
        this.brandScreen.init((BrandManager)this.brandManager);
        this.interactionScreen.setSupport(this.supportManager);
        this.languageScreen.init((BrandManager)this.brandManager, this.supportManager);
        super.performDefaults();
    }

    public boolean performOk() {
        this.brandManager.saveTo(this.applicationProject.getBrandManager());
        this.applicationProject.setInteractionTypeSupport(this.supportManager.getSupport());
        this.applicationProject.storeBuildPath();
        return true;
    }
}

