/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.interactive.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.desktop.model.interactive.core.InteractionType;
import org.eclipse.vtp.desktop.model.interactive.core.InteractionTypeManager;
import org.eclipse.vtp.desktop.model.interactive.core.internal.InteractionTypeSupport;
import org.eclipse.vtp.desktop.projects.interactive.core.util.InteractionSupportListener;

public class InteractionSupportManager {
    private List<InteractionSupportListener> listeners = new LinkedList<InteractionSupportListener>();
    private List<InteractionTypeSupport> originalSupport = null;
    private Map<String, SupportRecord> currentSupport = new HashMap<String, SupportRecord>();
    private List<InteractionType> installedTypes = InteractionTypeManager.getInstance().getInteractionTypes();

    public void init(List<InteractionTypeSupport> originalSupport) {
        this.originalSupport = originalSupport;
        this.currentSupport.clear();
        for (InteractionType installedType : this.installedTypes) {
            this.currentSupport.put(installedType.getId(), new SupportRecord(installedType));
        }
        for (InteractionTypeSupport typeSupport : originalSupport) {
            SupportRecord sr = this.currentSupport.get(typeSupport.getInteractionType());
            if (sr != null) {
                sr.setSupport(typeSupport);
                continue;
            }
            sr = new SupportRecord(typeSupport.getInteractionType(), typeSupport.getInteractionTypeName(), false, typeSupport);
            this.currentSupport.put(typeSupport.getInteractionType(), sr);
        }
        this.fireUpdate();
    }

    public List<SupportRecord> getCurrentSupport() {
        LinkedList<SupportRecord> ret = new LinkedList<SupportRecord>();
        ret.addAll(this.currentSupport.values());
        return ret;
    }

    public List<InteractionTypeSupport> getSupport() {
        ArrayList<InteractionTypeSupport> ret = new ArrayList<InteractionTypeSupport>();
        for (SupportRecord sr : this.currentSupport.values()) {
            if (!sr.isSupported()) continue;
            ret.add(sr.support);
        }
        return ret;
    }

    public void addListener(InteractionSupportListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removeListener(InteractionSupportListener listener) {
        this.listeners.remove(listener);
    }

    public void addSupport(SupportRecord record) {
        for (InteractionTypeSupport typeSupport : this.originalSupport) {
            if (!typeSupport.getInteractionType().equals(record.getId())) continue;
            record.setSupport(typeSupport);
            this.fireUpdate();
            return;
        }
        InteractionTypeSupport newSupport = new InteractionTypeSupport(record.getId(), record.getName());
        record.setSupport(newSupport);
        this.fireUpdate();
    }

    public void removeSupport(SupportRecord record) {
        record.setSupport(null);
        this.fireUpdate();
    }

    private void fireUpdate() {
        for (InteractionSupportListener listener : this.listeners) {
            listener.supportChanged();
        }
    }

    public class SupportRecord {
        String id = null;
        String name = null;
        boolean installed = false;
        InteractionTypeSupport support = null;

        public SupportRecord(InteractionType installedType) {
            this(installedType.getId(), installedType.getName(), true, null);
        }

        public SupportRecord(String id, String name, boolean installed, InteractionTypeSupport support) {
            this.id = id;
            this.name = name;
            this.installed = installed;
            this.support = support;
        }

        public boolean isSupported() {
            return this.support != null;
        }

        private void setSupport(InteractionTypeSupport support) {
            this.support = support;
        }

        public boolean isInstalled() {
            return this.installed;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public InteractionTypeSupport getSupport() {
            return this.support;
        }
    }
}

