/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.interactive.core.util;

import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.vtp.desktop.projects.interactive.core.util.InteractionSupportManager;

public class InteractionTypeConfigurationScreen
implements ICheckStateListener {
    private InteractionSupportManager supportManager = null;
    private CheckboxTableViewer viewer = null;

    public void setSupport(InteractionSupportManager supportManager) {
        this.supportManager = supportManager;
    }

    public Control createContents(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm sf = toolkit.createScrolledForm(parent);
        Composite comp = sf.getForm().getBody();
        comp.setLayout((Layout)new GridLayout(1, true));
        comp.setBackground(parent.getBackground());
        Section brandSection = toolkit.createSection(comp, 256);
        GridData gridData = new GridData(768);
        brandSection.setLayoutData((Object)gridData);
        brandSection.setText("Supported Interaction Types");
        Table table = new Table(comp, 67620);
        table.setHeaderVisible(true);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        table.setLayout((Layout)layout);
        TableColumn column = new TableColumn(table, 0);
        column.setText("Interaction Type");
        column.setWidth(100);
        column.setResizable(true);
        GridData gd = new GridData(768);
        gd.heightHint = 200;
        table.setLayoutData((Object)gd);
        this.viewer = new CheckboxTableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new InteractionTypeContentProvider());
        InteractionTypeLabelProvider labelProvider = new InteractionTypeLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setCheckStateProvider((ICheckStateProvider)labelProvider);
        this.viewer.addCheckStateListener((ICheckStateListener)this);
        this.viewer.setInput((Object)this);
        return comp;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        InteractionSupportManager.SupportRecord sr = (InteractionSupportManager.SupportRecord)event.getElement();
        if (event.getChecked()) {
            this.supportManager.addSupport(sr);
        } else {
            this.supportManager.removeSupport(sr);
        }
    }

    public class InteractionTypeContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            return InteractionTypeConfigurationScreen.this.supportManager.getCurrentSupport().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class InteractionTypeLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider,
    ICheckStateProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            InteractionSupportManager.SupportRecord sr = (InteractionSupportManager.SupportRecord)element;
            return String.valueOf(sr.getName()) + (sr.isInstalled() ? "" : " (Not Installed)");
        }

        public boolean isChecked(Object element) {
            InteractionSupportManager.SupportRecord sr = (InteractionSupportManager.SupportRecord)element;
            return sr.isSupported();
        }

        public boolean isGrayed(Object element) {
            return false;
        }
    }
}

