/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.interactive.core.util;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.vtp.desktop.model.core.branding.BrandManager;
import org.eclipse.vtp.desktop.projects.interactive.core.util.InteractionSupportListener;
import org.eclipse.vtp.desktop.projects.interactive.core.util.InteractionSupportManager;
import org.eclipse.vtp.desktop.projects.interactive.core.util.LanguageMappingScreen;

public class LanguageConfigurationScreen
implements InteractionSupportListener {
    private InteractionSupportManager supportManager = null;
    private BrandManager brandManager = null;
    private Composite comp = null;
    private Composite mappingComp = null;

    public void init(BrandManager brandManager, InteractionSupportManager supportManager) {
        this.brandManager = brandManager;
        this.supportManager = supportManager;
        supportManager.addListener(this);
    }

    public Control createContents(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm sf = toolkit.createScrolledForm(parent);
        this.comp = sf.getForm().getBody();
        this.comp.setBackground(parent.getBackground());
        this.comp.setBackgroundMode(1);
        this.comp.setLayout((Layout)new FillLayout());
        this.fillScreens();
        return this.comp;
    }

    private void fillScreens() {
        this.mappingComp = new Composite(this.comp, 0);
        this.mappingComp.setLayout((Layout)new GridLayout(1, true));
        boolean hasScreen = false;
        for (InteractionSupportManager.SupportRecord sr : this.supportManager.getCurrentSupport()) {
            if (!sr.isSupported()) continue;
            LanguageMappingScreen screen = new LanguageMappingScreen();
            screen.init(this.brandManager, sr);
            Composite child = new Composite(this.mappingComp, 0);
            child.setLayoutData((Object)new GridData(1808));
            child.setLayout((Layout)new FillLayout());
            screen.createContents(child);
            hasScreen = true;
        }
        if (!hasScreen) {
            Composite messageComp = new Composite(this.mappingComp, 0);
            messageComp.setLayoutData((Object)new GridData(1808));
            messageComp.setLayout((Layout)new FillLayout());
            Label errorMessage = new Label(messageComp, 0);
            errorMessage.setText("You have not selected any interaction types.  Please go back to the Interaction Types screen and select one.");
        }
        this.comp.layout(true, true);
    }

    @Override
    public void supportChanged() {
        this.mappingComp.dispose();
        this.fillScreens();
    }
}

