/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.interactive.core.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.vtp.desktop.model.core.branding.BrandManager;
import org.eclipse.vtp.desktop.model.core.branding.BrandManagerListener;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.internal.branding.Brand;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaProject;
import org.eclipse.vtp.desktop.model.interactive.core.InteractiveWorkflowCore;
import org.eclipse.vtp.desktop.model.interactive.core.internal.InteractionTypeSupport;
import org.eclipse.vtp.desktop.model.interactive.core.internal.LanguageSupport;
import org.eclipse.vtp.desktop.projects.core.dialogs.BrandDialog;
import org.eclipse.vtp.desktop.projects.interactive.core.dialogs.LanguageConfigurationDialog;
import org.eclipse.vtp.desktop.projects.interactive.core.util.InteractionSupportManager;
import org.eclipse.vtp.framework.util.Guid;

public class LanguageMappingScreen {
    private InteractionSupportManager.SupportRecord supportRecord = null;
    private BrandManager brandManager = null;
    private TreeViewer brandViewer = null;
    private InteractionTypeSupport support = null;
    private List<IMediaProject> mediaProjects = InteractiveWorkflowCore.getDefault().getInteractiveWorkflowModel().listMediaProjects();

    public void init(BrandManager brandManager, InteractionSupportManager.SupportRecord supportRecord) {
        this.brandManager = brandManager;
        brandManager.addListener(new BrandManagerListener(){

            public void brandRemoved(IBrand brand) {
            }

            public void brandParentChanged(IBrand brand, IBrand oldParent) {
            }

            public void brandNameChanged(IBrand brand, String oldName) {
                if (LanguageMappingScreen.this.brandViewer != null) {
                    LanguageMappingScreen.this.brandViewer.refresh();
                }
            }

            public void brandAdded(IBrand brand) {
                if (LanguageMappingScreen.this.brandViewer != null) {
                    LanguageMappingScreen.this.brandViewer.refresh();
                }
            }
        });
        this.supportRecord = supportRecord;
        this.support = supportRecord.getSupport();
    }

    public Control createContents(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm sf = toolkit.createScrolledForm(parent);
        Composite comp = sf.getForm().getBody();
        comp.setLayout((Layout)new GridLayout());
        comp.setBackground(parent.getBackground());
        Section brandSection = toolkit.createSection(comp, 256);
        GridData gridData = new GridData(768);
        brandSection.setLayoutData((Object)gridData);
        brandSection.setText(this.supportRecord.getName());
        final Composite treeComp = new Composite(comp, 0);
        treeComp.setLayout((Layout)new FillLayout());
        GridData gridData2 = new GridData(768);
        gridData2.minimumHeight = 125;
        gridData2.heightHint = 125;
        treeComp.setLayoutData((Object)gridData2);
        this.createTree(treeComp);
        final Button languageButton = new Button(comp, 8);
        languageButton.setText("Configure Languages");
        GridData gd = new GridData(768);
        gd.horizontalAlignment = 131072;
        languageButton.setLayoutData((Object)gd);
        languageButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                LanguageConfigurationDialog lcd = new LanguageConfigurationDialog(languageButton.getShell());
                lcd.setCurrentSupport(LanguageMappingScreen.this.support);
                if (lcd.open() == 0) {
                    LanguageMappingScreen.this.brandViewer.getControl().dispose();
                    LanguageMappingScreen.this.createTree(treeComp);
                    treeComp.layout(true, true);
                }
            }
        });
        this.hookContextMenu();
        return comp;
    }

    private void createTree(Composite parent) {
        Tree tree = new Tree(parent, 67588);
        tree.setHeaderVisible(true);
        this.brandViewer = new TreeViewer(tree);
        TreeColumn brandColumn = new TreeColumn(tree, 0);
        brandColumn.setWidth(100);
        brandColumn.setText("Brands");
        for (LanguageSupport language : this.support.getSupportedLanguages()) {
            TreeViewerColumn languageColumn = new TreeViewerColumn(this.brandViewer, 0);
            languageColumn.getColumn().setText(language.getLanguage());
            languageColumn.getColumn().setWidth(100);
            ProjectEditingSupport pes = new ProjectEditingSupport(this.brandViewer, language);
            languageColumn.setEditingSupport((EditingSupport)pes);
        }
        this.brandViewer.setContentProvider((IContentProvider)new BrandContentProvider());
        this.brandViewer.setLabelProvider((IBaseLabelProvider)new BrandLabelProvider());
        this.brandViewer.setInput((Object)this);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LanguageMappingScreen.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.brandViewer.getControl());
        this.brandViewer.getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        IStructuredSelection sel = (IStructuredSelection)this.brandViewer.getSelection();
        if (!sel.isEmpty()) {
            final IBrand brand = (IBrand)sel.getFirstElement();
            manager.add((IAction)new Action("Add Brand"){

                public void run() {
                    Shell workbenchShell = Display.getCurrent().getActiveShell();
                    BrandDialog bd = new BrandDialog(workbenchShell);
                    bd.setReservedNames(LanguageMappingScreen.this.getBrandNames(brand));
                    if (bd.open() == 0) {
                        Brand nbrand = new Brand(Guid.createGUID(), bd.getBrandName());
                        nbrand.setParent(brand);
                        LanguageMappingScreen.this.brandViewer.refresh((Object)brand);
                    }
                }
            });
            if (!this.brandManager.getDefaultBrand().getId().equals(brand.getId())) {
                manager.add((IAction)new Action("Remove Brand"){

                    public void run() {
                        IBrand parentBrand = brand.getParent();
                        brand.delete();
                        LanguageMappingScreen.this.brandViewer.refresh((Object)parentBrand);
                    }
                });
            }
        }
    }

    private List<String> getBrandNames(IBrand brand) {
        ArrayList<String> ret = new ArrayList<String>();
        for (IBrand child : brand.getChildBrands()) {
            ret.add(child.getName());
        }
        return ret;
    }

    private class BrandContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private BrandContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return new Object[]{LanguageMappingScreen.this.brandManager.getDefaultBrand()};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            return ((IBrand)parentElement).getChildBrands().toArray();
        }

        public Object getParent(Object element) {
            return ((IBrand)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return ((IBrand)element).getChildBrands().size() > 0;
        }
    }

    private class BrandLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private BrandLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IBrand brand = (IBrand)element;
            if (columnIndex == 0) {
                return brand.getName();
            }
            LanguageSupport language = (LanguageSupport)LanguageMappingScreen.this.support.getSupportedLanguages().get(columnIndex - 1);
            String mediaProjectId = language.getMediaProjectId(brand, false);
            if (mediaProjectId != null) {
                IMediaProject mediaProject = InteractiveWorkflowCore.getDefault().getInteractiveWorkflowModel().getMediaProject(mediaProjectId);
                if (mediaProject == null) {
                    return "Not Found (" + mediaProjectId + ")";
                }
                return mediaProject.getName();
            }
            if (brand.equals(LanguageMappingScreen.this.brandManager.getDefaultBrand())) {
                return "Not Configured";
            }
            return language.getMediaProjectId(brand) == null ? "NotConfigured" : "Inherit From Parent";
        }
    }

    public class ProjectEditingSupport
    extends EditingSupport {
        ComboBoxCellEditor defaultBrandEditor;
        ComboBoxCellEditor subBrandEditor;
        LanguageSupport language;

        public ProjectEditingSupport(TreeViewer viewer, LanguageSupport language) {
            super((ColumnViewer)viewer);
            this.defaultBrandEditor = null;
            this.subBrandEditor = null;
            this.language = null;
            this.language = language;
            String[] defaultItems = new String[LanguageMappingScreen.this.mediaProjects.size() + 1];
            defaultItems[0] = "Not Configured";
            String[] subItems = new String[LanguageMappingScreen.this.mediaProjects.size() + 1];
            subItems[0] = "Inherit From Parent";
            int i = 0;
            while (i < LanguageMappingScreen.this.mediaProjects.size()) {
                defaultItems[i + 1] = ((IMediaProject)LanguageMappingScreen.this.mediaProjects.get(i)).getName();
                subItems[i + 1] = ((IMediaProject)LanguageMappingScreen.this.mediaProjects.get(i)).getName();
                ++i;
            }
            this.defaultBrandEditor = new ComboBoxCellEditor((Composite)viewer.getTree(), defaultItems, 12);
            this.subBrandEditor = new ComboBoxCellEditor((Composite)viewer.getTree(), subItems, 12);
        }

        public void modify(Object element, String property, Object value) {
            IBrand brand = (IBrand)((TreeItem)element).getData();
            LanguageSupport ls = LanguageMappingScreen.this.support.getLanguageSupport(property);
            if (value.equals("Inherit From Parent") || value.equals("Not Configured")) {
                ls.assignMediaProject(brand.getId(), null);
            } else {
                IMediaProject mediaProject = (IMediaProject)value;
                ls.assignMediaProject(brand.getId(), mediaProject.getId());
            }
            LanguageMappingScreen.this.brandViewer.refresh();
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            IBrand brand = (IBrand)element;
            if (brand.getParent() == null) {
                return this.defaultBrandEditor;
            }
            return this.subBrandEditor;
        }

        protected Object getValue(Object element) {
            Integer ret;
            block5: {
                ret = new Integer(0);
                System.out.println("in get value");
                try {
                    IBrand brand = (IBrand)element;
                    String mediaProjectId = this.language.getMediaProjectId(brand, false);
                    System.out.println("media project id: " + mediaProjectId);
                    if (mediaProjectId == null) {
                        ret = new Integer(0);
                        break block5;
                    }
                    int i = 0;
                    while (i < LanguageMappingScreen.this.mediaProjects.size()) {
                        if (((IMediaProject)LanguageMappingScreen.this.mediaProjects.get(i)).getId().equals(mediaProjectId)) {
                            ret = new Integer(i + 1);
                            break;
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            System.out.println(ret);
            return ret;
        }

        protected void setValue(Object element, Object value) {
            System.out.println(value);
            IBrand brand = (IBrand)element;
            int vi = (Integer)value;
            if (vi == 0) {
                this.language.assignMediaProject(brand.getId(), null);
            } else {
                this.language.assignMediaProject(brand.getId(), ((IMediaProject)LanguageMappingScreen.this.mediaProjects.get(vi - 1)).getId());
            }
            this.getViewer().refresh();
        }
    }
}

